/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.value;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;

import org.h2.message.Message;

/**
 * @author Thomas
 */
public class ValueDate extends Value {
    public static final int PRECISION = 8;

    private Date value;

    private ValueDate(Date value) {
        // this class is mutable - must copy the object
        Calendar cal = Calendar.getInstance();
        cal.setTime(value);
        // TODO gcj: required so that the millis are calculated?
        cal.get(Calendar.YEAR);        
        cal.set(Calendar.MILLISECOND, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.HOUR_OF_DAY, 0);
        this.value = new Date(cal.getTime().getTime());
    }

    public static Date parseDate(String s) throws SQLException {
        return (Date) DataType.parseDateTime(s, Value.DATE, Message.DATE_CONSTANT_1);
    }

    public Date getDate() {
        // this class is mutable - must copy the object
        return (Date)value.clone();
    }

    public String getSQL() {
        return "DATE '" + getString() + "'";
    }

    public int getType() {
        return Value.DATE;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueDate v = (ValueDate) o;
        int c = value.compareTo(v.value);
        return c == 0 ? 0 : (c < 0 ? -1 : 1);
    }

    public String getString() {
        return value.toString();
    }

    public long getPrecision() {
        return PRECISION;
    }

    public int hashCode() {
        return value.hashCode();
    }

    public Object getObject() {
        // this class is mutable - must copy the object
        return getDate();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDate(parameterIndex, value);
    }

    public static ValueDate get(Date date) {
        return (ValueDate) Value.cache(new ValueDate(date));
    }

//    public String getJavaString() {
//        return "Date.valueOf(\"" + toString() + "\")";
//    }
    
    public int getDisplaySize() {
        return "2001-01-01".length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueDate && value.equals(((ValueDate)v).value);
    }    

}
