/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.tools.SimpleResultSet;

public class Function {
    public static void main(String[] args) throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:mem:", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("CREATE ALIAS ISPRIME FOR \"org.h2.samples.Function.isPrime\" ");
        ResultSet rs = stat.executeQuery("SELECT ISPRIME(X), X FROM SYSTEM_RANGE(1, 20) ORDER BY X");
        while (rs.next()) {
            boolean isPrime = rs.getBoolean(1);
            if (!isPrime) continue;
            int x = rs.getInt(2);
            System.out.println(x + " is prime");
        }
        conn.close();
    }

    public static boolean isPrime(int value) {
        return new BigInteger(String.valueOf(value)).isProbablePrime(100);
    }

    public static ResultSet query(Connection conn, String sql) throws SQLException {
        return conn.createStatement().executeQuery(sql);
    }

    public static ResultSet simpleResultSet() throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("ID", 4, 10, 0);
        rs.addColumn("NAME", 12, 255, 0);
        rs.addRow(new Object[]{new Integer(0), "Hello"});
        return rs;
    }

    public static ResultSet getMatrix(Connection conn, Integer id) throws SQLException {
        SimpleResultSet rs = new SimpleResultSet();
        rs.addColumn("X", 4, 10, 0);
        rs.addColumn("Y", 4, 10, 0);
        if (id == null) {
            return rs;
        }
        for (int x = 0; x < id; ++x) {
            for (int y = 0; y < id; ++y) {
                rs.addRow(new Object[]{new Integer(x), new Integer(y)});
            }
        }
        return rs;
    }
}

