/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileUtil;
import org.seasar.framework.util.URLUtil;

public class JarFileUtil {
    private JarFileUtil() {
    }

    public static JarFile create(File file) {
        try {
            return new JarFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static InputStream getInputStream(JarFile file, ZipEntry entry) {
        try {
            return file.getInputStream(entry);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static JarFile toJarFile(URL jarUrl) {
        return JarFileUtil.create(new File(JarFileUtil.toJarFilePath(jarUrl)));
    }

    public static String toJarFilePath(URL jarUrl) {
        URL nestedUrl = URLUtil.create(jarUrl.getPath());
        String nestedUrlPath = nestedUrl.getPath();
        int pos = nestedUrlPath.lastIndexOf(33);
        String jarFilePath = nestedUrlPath.substring(0, pos);
        File jarFile = new File(URLUtil.decode(jarFilePath, "UTF8"));
        return FileUtil.getCanonicalPath(jarFile);
    }
}

