/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.SQLException;
import org.h2.tools.Server;
import org.h2.util.StartBrowser;
import snoozesoft.systray4j.SysTrayMenu;
import snoozesoft.systray4j.SysTrayMenuEvent;
import snoozesoft.systray4j.SysTrayMenuIcon;
import snoozesoft.systray4j.SysTrayMenuItem;
import snoozesoft.systray4j.SysTrayMenuListener;

public class SysTray
implements SysTrayMenuListener {
    Server tcp;
    Server web;
    Server odbc;

    public static void main(String[] args) throws Exception {
        new SysTray().run(args);
    }

    private void startBrowser() {
        if (this.web != null) {
            StartBrowser.openURL(this.web.getURL());
        }
    }

    private void run(String[] args) {
        try {
            this.web = Server.createWebServer(args);
            this.web.start();
            this.tcp = Server.createTcpServer(args).start();
            this.odbc = Server.createOdbcServer(args).start();
            this.createMenu();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 90061) {
                System.out.println("Port is in use, maybe another server server already running on " + this.web.getURL());
            }
            e.printStackTrace();
        }
        StartBrowser.openURL(this.web.getURL());
        if (!this.web.isRunning()) {
            System.exit(1);
        }
    }

    public void menuItemSelected(SysTrayMenuEvent e) {
        if (e.getActionCommand().equals("exit")) {
            System.exit(0);
        } else if (e.getActionCommand().equals("open")) {
            this.startBrowser();
        }
    }

    public void iconLeftClicked(SysTrayMenuEvent e) {
        this.startBrowser();
    }

    public void iconLeftDoubleClicked(SysTrayMenuEvent e) {
        this.startBrowser();
    }

    void createMenu() {
        SysTrayMenuItem itemExit = new SysTrayMenuItem("Exit", "exit");
        itemExit.addSysTrayMenuListener(this);
        SysTrayMenuItem itemOpen = new SysTrayMenuItem("H2 Console", "open");
        itemOpen.addSysTrayMenuListener(this);
        SysTrayMenuIcon icon = new SysTrayMenuIcon(this.getClass().getResource("/org/h2/h2.ico"));
        SysTrayMenu menu = new SysTrayMenu(icon, "H2 Console");
        icon.addSysTrayMenuListener(this);
        menu.addItem(itemExit);
        menu.addSeparator();
        menu.addItem(itemOpen);
    }
}

