/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriDataテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuriData {

	private Long dataID;
	private String pkeyVal;
	private Long pkeyNum;
	private String dataType = "";
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataID() {
		return dataID;
	}

	/**
	 * DataIDを設定します。
	 * @param dataID DataID
	 */
	public void setDataID(Long dataID) {
		modifiedPropertySet.add("dataID");
		this.dataID = dataID;
	}

	/**
	 * pkeyValを返します。
	 * @return pkeyVal
	 */
	@org.seasar.dao.annotation.tiger.Column("pkeyVal")
	public String getPkeyVal() {
		return pkeyVal;
	}

	/**
	 * pkeyValを設定します。
	 * @param pkeyVal pkeyVal
	 */
	public void setPkeyVal(String pkeyVal) {
		modifiedPropertySet.add("pkeyVal");
		this.pkeyVal = pkeyVal;
	}

	/**
	 * pkeyNumを返します。
	 * @return pkeyNum
	 */
	@org.seasar.dao.annotation.tiger.Column("pkeyNum")
	public Long getPkeyNum() {
		return pkeyNum;
	}

	/**
	 * pkeyNumを設定します。
	 * @param pkeyNum pkeyNum
	 */
	public void setPkeyNum(Long pkeyNum) {
		modifiedPropertySet.add("pkeyNum");
		this.pkeyNum = pkeyNum;
	}

	/**
	 * dataTypeを返します。
	 * @return dataType
	 */
	@org.seasar.dao.annotation.tiger.Column("dataType")
	public String getDataType() {
		return dataType;
	}

	/**
	 * dataTypeを設定します。
	 * @param dataType dataType
	 */
	public void setDataType(String dataType) {
		modifiedPropertySet.add("dataType");
		this.dataType = dataType;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/dataID=").append(dataID);
		buff.append("/pkeyVal=").append(pkeyVal);
		buff.append("/pkeyNum=").append(pkeyNum);
		buff.append("/dataType=").append(dataType);
		buff.append("]");
		return buff.toString();
	}

}
