/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * BuriPathテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class BuriPathCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	BuriPathCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public BuriPathCondition() {
		this.alias = "BuriPath";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * PathIDの検索条件を返します。
	 * @return PathIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectPathID() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"PathID", getClass()));
	}


	/**
	 * PathNameの検索条件を返します。
	 * @return PathNameの検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectPathName() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"PathName", getClass()));
	}


	/**
	 * RealPathNameの検索条件を返します。
	 * @return RealPathNameの検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectRealPathName() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"RealPathName", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
