/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * BuriDataPathHistoryテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class BuriDataPathHistoryCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	BuriDataPathHistoryCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public BuriDataPathHistoryCondition() {
		this.alias = "BuriDataPathHistory";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * historyIDの検索条件を返します。
	 * @return historyIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectHistoryID() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"historyID", getClass()));
	}


	/**
	 * PathIDの検索条件を返します。
	 * @return PathIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectPathID() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"PathID", getClass()));
	}


	/**
	 * DataIDの検索条件を返します。
	 * @return DataIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectDataID() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"DataID", getClass()));
	}


	/**
	 * UserIDValの検索条件を返します。
	 * @return UserIDValの検索条件
	 */
	public org.seasar.codegen.lib.impl.StringConditionElementImpl<String> selectUserIDVal() {
		return new org.seasar.codegen.lib.impl.StringConditionElementImpl<String>(conditionResult, new ColumnImpl(this.alias,"UserIDVal", getClass()));
	}


	/**
	 * UserIDNumの検索条件を返します。
	 * @return UserIDNumの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Integer> selectUserIDNum() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Integer>(conditionResult, new ColumnImpl(this.alias,"UserIDNum", getClass()));
	}


	/**
	 * insertDateの検索条件を返します。
	 * @return insertDateの検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectInsertDate() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"insertDate", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
