/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriStateテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuristate {

	private Long stateid;
	private Long pathid;
	private Long dataid;
	private Long branchid;
	private String useridval;
	private Integer useridnum;
	private java.util.Date insertdate;
	private java.util.Date processdate;
	private Long versionno;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * StateIDを返します。
	 * @return StateID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("StateID")
	public Long getStateid() {
		return stateid;
	}

	/**
	 * StateIDを設定します。
	 * @param stateid StateID
	 */
	public void setStateid(Long stateid) {
		modifiedPropertySet.add("stateid");
		this.stateid = stateid;
	}

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathid() {
		return pathid;
	}

	/**
	 * PathIDを設定します。
	 * @param pathid PathID
	 */
	public void setPathid(Long pathid) {
		modifiedPropertySet.add("pathid");
		this.pathid = pathid;
	}

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataid() {
		return dataid;
	}

	/**
	 * DataIDを設定します。
	 * @param dataid DataID
	 */
	public void setDataid(Long dataid) {
		modifiedPropertySet.add("dataid");
		this.dataid = dataid;
	}

	/**
	 * BranchIDを返します。
	 * @return BranchID
	 */
	@org.seasar.dao.annotation.tiger.Column("BranchID")
	public Long getBranchid() {
		return branchid;
	}

	/**
	 * BranchIDを設定します。
	 * @param branchid BranchID
	 */
	public void setBranchid(Long branchid) {
		modifiedPropertySet.add("branchid");
		this.branchid = branchid;
	}

	/**
	 * UserIDValを返します。
	 * @return UserIDVal
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDVal")
	public String getUseridval() {
		return useridval;
	}

	/**
	 * UserIDValを設定します。
	 * @param useridval UserIDVal
	 */
	public void setUseridval(String useridval) {
		modifiedPropertySet.add("useridval");
		this.useridval = useridval;
	}

	/**
	 * UserIDNumを返します。
	 * @return UserIDNum
	 */
	@org.seasar.dao.annotation.tiger.Column("UserIDNum")
	public Integer getUseridnum() {
		return useridnum;
	}

	/**
	 * UserIDNumを設定します。
	 * @param useridnum UserIDNum
	 */
	public void setUseridnum(Integer useridnum) {
		modifiedPropertySet.add("useridnum");
		this.useridnum = useridnum;
	}

	/**
	 * insertDateを返します。
	 * @return insertDate
	 */
	@org.seasar.dao.annotation.tiger.Column("insertDate")
	public java.util.Date getInsertdate() {
		return insertdate;
	}

	/**
	 * insertDateを設定します。
	 * @param insertdate insertDate
	 */
	public void setInsertdate(java.util.Date insertdate) {
		modifiedPropertySet.add("insertdate");
		this.insertdate = insertdate;
	}

	/**
	 * processDateを返します。
	 * @return processDate
	 */
	@org.seasar.dao.annotation.tiger.Column("processDate")
	public java.util.Date getProcessdate() {
		return processdate;
	}

	/**
	 * processDateを設定します。
	 * @param processdate processDate
	 */
	public void setProcessdate(java.util.Date processdate) {
		modifiedPropertySet.add("processdate");
		this.processdate = processdate;
	}

	/**
	 * versionNoを返します。
	 * @return versionNo
	 */
	@org.seasar.dao.annotation.tiger.Column("versionNo")
	public Long getVersionno() {
		return versionno;
	}

	/**
	 * versionNoを設定します。
	 * @param versionno versionNo
	 */
	public void setVersionno(Long versionno) {
		modifiedPropertySet.add("versionno");
		this.versionno = versionno;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/stateid=").append(stateid);
		buff.append("/pathid=").append(pathid);
		buff.append("/dataid=").append(dataid);
		buff.append("/branchid=").append(branchid);
		buff.append("/useridval=").append(useridval);
		buff.append("/useridnum=").append(useridnum);
		buff.append("/insertdate=").append(insertdate);
		buff.append("/processdate=").append(processdate);
		buff.append("/versionno=").append(versionno);
		buff.append("]");
		return buff.toString();
	}

}
