/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.entity;

import java.util.Set;
import java.util.HashSet;

/**
 * BuriBranchテーブルのEntityです。
 * @author S2Dao-CodeGen
 */


public abstract class AbstractBuribranch {

	private Long branchid;
	private Long parentbranchid;
	private Long pathid;
	private Long dataid;
	private java.util.Date processdate;
	private Long versionno;
	private Long entity_count;
	
	private Set<String> modifiedPropertySet = new HashSet<String>();

	/**
	 * BranchIDを返します。
	 * @return BranchID
	 */
	@org.seasar.dao.annotation.tiger.Id(value=org.seasar.dao.annotation.tiger.IdType.ASSIGNED)
	@org.seasar.dao.annotation.tiger.Column("BranchID")
	public Long getBranchid() {
		return branchid;
	}

	/**
	 * BranchIDを設定します。
	 * @param branchid BranchID
	 */
	public void setBranchid(Long branchid) {
		modifiedPropertySet.add("branchid");
		this.branchid = branchid;
	}

	/**
	 * parentBranchIDを返します。
	 * @return parentBranchID
	 */
	@org.seasar.dao.annotation.tiger.Column("parentBranchID")
	public Long getParentbranchid() {
		return parentbranchid;
	}

	/**
	 * parentBranchIDを設定します。
	 * @param parentbranchid parentBranchID
	 */
	public void setParentbranchid(Long parentbranchid) {
		modifiedPropertySet.add("parentbranchid");
		this.parentbranchid = parentbranchid;
	}

	/**
	 * PathIDを返します。
	 * @return PathID
	 */
	@org.seasar.dao.annotation.tiger.Column("PathID")
	public Long getPathid() {
		return pathid;
	}

	/**
	 * PathIDを設定します。
	 * @param pathid PathID
	 */
	public void setPathid(Long pathid) {
		modifiedPropertySet.add("pathid");
		this.pathid = pathid;
	}

	/**
	 * DataIDを返します。
	 * @return DataID
	 */
	@org.seasar.dao.annotation.tiger.Column("DataID")
	public Long getDataid() {
		return dataid;
	}

	/**
	 * DataIDを設定します。
	 * @param dataid DataID
	 */
	public void setDataid(Long dataid) {
		modifiedPropertySet.add("dataid");
		this.dataid = dataid;
	}

	/**
	 * processDateを返します。
	 * @return processDate
	 */
	@org.seasar.dao.annotation.tiger.Column("processDate")
	public java.util.Date getProcessdate() {
		return processdate;
	}

	/**
	 * processDateを設定します。
	 * @param processdate processDate
	 */
	public void setProcessdate(java.util.Date processdate) {
		modifiedPropertySet.add("processdate");
		this.processdate = processdate;
	}

	/**
	 * versionNoを返します。
	 * @return versionNo
	 */
	@org.seasar.dao.annotation.tiger.Column("versionNo")
	public Long getVersionno() {
		return versionno;
	}

	/**
	 * versionNoを設定します。
	 * @param versionno versionNo
	 */
	public void setVersionno(Long versionno) {
		modifiedPropertySet.add("versionno");
		this.versionno = versionno;
	}

	/**
	 * countを返します。
	 * @return count
	 */
	@org.seasar.dao.annotation.tiger.Column("count")
	public Long getEntity_count() {
		return entity_count;
	}

	/**
	 * countを設定します。
	 * @param entity_count count
	 */
	public void setEntity_count(Long entity_count) {
		modifiedPropertySet.add("entity_count");
		this.entity_count = entity_count;
	}


	/**
	 * setterが呼ばれたプロパティのセットを返します。
	 * @return settterが呼ばれたプロパティのセット
	 */
	public Set<String> getModifiedPropertyNames() {
		return this.modifiedPropertySet;
	}

	public String toString() {
		StringBuilder buff = new StringBuilder("[");
		buff.append("/branchid=").append(branchid);
		buff.append("/parentbranchid=").append(parentbranchid);
		buff.append("/pathid=").append(pathid);
		buff.append("/dataid=").append(dataid);
		buff.append("/processdate=").append(processdate);
		buff.append("/versionno=").append(versionno);
		buff.append("/entity_count=").append(entity_count);
		buff.append("]");
		return buff.toString();
	}

}
