/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.sample.camel.dao;

import java.util.List;

import org.seasar.codegen.sample.camel.entity.Buridata;
import org.seasar.codegen.sample.camel.condition.BuridataCondition;
/**
 * BuriDataテーブルに対応するDaoの中核部分です。
 * このDaoはgeneration gapを使用しているので、処理を追加するときはBuridataDaoに処理を記述します。
 * @author S2Dao-CodeGen
 */
@org.seasar.dao.annotation.tiger.S2Dao(bean = Buridata.class)
@org.seasar.codegen.lib.annotation.SqlFileEncoding("UTF-8")
public interface BuridataCore {

	/**
	 * BuriDataのEntityを全て取得します。主キーが複合主キーでない場合は主キーでソートします。
	 *
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Query("ORDER BY DataID")
	public List<Buridata> getAllBuridata();


	/**
	 * 引数が主キーと一致するBuriDataのEntityを取得します。
	 *
	 * @param dataid 主キー
	 * @return Entity。一致しない場合は<code>null</code>
	 */
	@org.seasar.dao.annotation.tiger.Query("DataID = ?")
	public Buridata getBuridata(Long dataid);


	/**
	 * 引数が主キーと一致するBuriDataのEntityのリストを主キーでソートして取得します。
	 *
	 * @param dataids  主キーの配列
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("dataids")
	@org.seasar.dao.annotation.tiger.Query("DataID in /*dataids*/(1) ORDER BY DataID")
	public List<Buridata> getBuridataByIds(Long ... dataids);
	

	/**
	 * Conditionに指定した検索条件と一致するEntityのリストを取得します。
	 *
	 * @param dto 検索条件を指定したCondition
	 * @return Entityのリスト
	 */
	@org.seasar.dao.annotation.tiger.Arguments("condition")
	public List<Buridata> find(BuridataCondition condition);

	/**
	 * Conditionに指定した検索条件と一致するEntityを取得します。
	 *
	 * @param dto 検索条件を指定したFindDto
	 * @return Entityに対応するDto。一致しない場合は<code>null</code>
	 * @throws org.seasar.dao.NotSingleResultRuntimeException 結果が2件以上だった場合
	 */
	public Buridata soleMatch(BuridataCondition condition);

	/**
	 * Entityを追加します。
	 *
	 * @param entity 追加するEntity
	 */
	public void insert(Buridata entity);
	/**
	 * Entityを更新します。
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void update(Buridata entity);

	/**
	 * Entityを削除します。
	 *
	 * @param entity 削除するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void delete(Buridata entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します.	 
	 *
	 * @param entity 更新するEntity
	 * @throws org.seasar.dao.NotSingleRowUpdatedRuntimeException 更新結果が0件の場合
	 */
	public void updateModifiedOnly(Buridata entity);

	/**
	 * Entityを更新します。このメソッドは更新結果が0件の時例外を投げません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	 @org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	 public int updateNonCheck(Buridata entity);

	/**
	 * Entityのプロパティのうち、setterが呼ばれたプロパティのみを更新します。このメソッドは更新結果が0件の時例外を返しません。
	 * @param entity Entity
	 * @return 更新結果の件数
	 */
	@org.seasar.dao.annotation.tiger.CheckSingleRowUpdate(false)
	public int updateNonCheckModifiedOnly(Buridata entity);
	/**
	 * 追加をバッチ更新で行います。
	 * @param entityList 追加するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] insertBatch(List<Buridata> entityList);
	/**
	 * 更新をバッチ更新で行います。
	 * @param entityList 更新するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] updateBatch(List<Buridata> entityList);

	/**
	 * 削除をバッチ更新で行います。
	 * @param EntityList 削除するEntityのリスト
	 * @return 更新カウントの配列。
	 */
	 public int[] deleteBatch(List<Buridata> entityList);

}

