/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.codegen.util;

import java.util.Iterator;
import java.util.Map;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkUtil {
    private LinkUtil() {
    }

    public static void setupChildLinks(Map<String, Table> tableMap) {
        Iterator<Table> i = tableMap.values().iterator();
        while (i.hasNext()) {
            LinkUtil.setupChildLinks(i.next(), tableMap);
        }
    }

    private static void setupChildLinks(Table child, Map<String, Table> tableMap) {
        for (LinkTable parentLink : child.getParentTable()) {
            String tableName = parentLink.getTableName();
            Table parent = tableMap.get(tableName);
            LinkTable childLink = LinkUtil.getChildLink(child, parentLink);
            parent.addChildTable(tableName, childLink);
        }
    }

    private static LinkTable getChildLink(Table child, LinkTable parentLink) {
        LinkTable link = new LinkTable();
        link.setTableName(child.getTableName());
        link.setParentFieldName(parentLink.getParentFieldName());
        link.setChildFieldName(parentLink.getChildFieldName());
        return link;
    }
}

