/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.convert.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.seasar.codegen.convert.NameConverter;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.LinkTable;
import org.seasar.codegen.element.PrimaryKey;
import org.seasar.codegen.element.Table;

/**
 * 
 * @author azusa
 */
public abstract class AbstractConverter implements NameConverter {

    @SuppressWarnings("unchecked")
    public void convert(Map<?, Object> map) {
        Iterator<Object> it = map.values().iterator();
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Table) {
                convertTable((Table) value);
            } else if (value instanceof Map) {
                convert((Map<?, Object>) value);
            } else if (value instanceof List) {
                List list = (List) value;
                for (int i = 0; i < list.size(); i++) {
                    convertTable((Table) list.get(i));
                }
            } else {
                continue;
            }
        }
    }

    private void convertTable(Table table) {
        table.setTableNameForDto(convertClassName(table.getTableName()));

        List<Field> fieldList = table.getTableField();
        for (int i = 0; i < fieldList.size(); i++) {
            Field field = (Field) fieldList.get(i);
            field.setFieldNameForDto(convertFieldName(field.getFieldName()));
        }
        List<PrimaryKey> pkList = table.getPrimaryKey();
        for (int i = 0; i < pkList.size(); i++) {
            PrimaryKey pk = (PrimaryKey) pkList.get(i);
            pk.getField().setFieldNameForDto(
                    convertFieldName(pk.getField().getFieldName()));
        }
        List<LinkTable> parentTables = table.getParentTable();
        for (int i = 0; i < parentTables.size(); i++) {
            LinkTable linkTable = (LinkTable) parentTables.get(i);
            linkTable.setParentFieldNameForDto(convertFieldName(linkTable
                    .getParentFieldName()));
            linkTable.setTableNameForDto(convertClassName(linkTable
                    .getTableName()));
        }
        List<LinkTable> childTables = table.getChildTable();
        for (int i = 0; i < childTables.size(); i++) {
            LinkTable linkTable = (LinkTable) childTables.get(i);
            linkTable.setParentFieldNameForDto(convertFieldName(linkTable
                    .getParentFieldName()));
            linkTable.setTableNameForDto(convertClassName(linkTable
                    .getTableName()));
        }
    }
}
