/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.impl;

import java.io.File;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.seasar.codegen.Resource;
import org.seasar.codegen.element.Table;

import freemarker.template.Configuration;

@Resource
public class NormalDiconOutputCodeImpl extends AbstractEntityOutputCodeImpl {

    public NormalDiconOutputCodeImpl() {
        super.setTemplateFileName("dicon.ftl");
        super.setFileNameFtl("alldao.dicon");

    }

    public void generateCode(File baseDir, Map<String, Table> tableList) {
        if (getFileNameFtl().equals("alldao.dicon")
                && (!codegenConfig.isOutputAllDaoDicon())) {
            return;
        }
        Configuration cfg = getConfiguration();
        Map<String, Object> root = createRootObj(tableList);
        convetName(root);
        Writer out = createWriter(baseDir, root);
        processTemplate(cfg, root, out);
        destroyWriter(out);
    }

    protected Map<String, Object> createRootObj(Map<String, Table> tableList) {
        Map<String, Object> root = createRootObj(tableList, "");
        List<Table> list = new ArrayList<Table>(tableList.values());
        root.put("tableList", list);
        return root;
    }

}
