/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.tiger.impl;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.tiger.FetchHandler;
import org.seasar.dao.tiger.impl.FetchBeanMetaDataResultSetHandler;
import org.seasar.dao.tiger.impl.FetchDtoMetaDataResultSetHandler;
import org.seasar.dao.tiger.impl.FetchMapResultSetHandler;
import org.seasar.dao.tiger.impl.FetchObjectResultSetHandler;
import org.seasar.dao.util.TypeUtil;
import org.seasar.extension.jdbc.ResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FetchResultSetHandler
implements ResultSetHandler {
    protected Class<?> beanClass;
    protected BeanMetaData beanMetaData;
    protected DtoMetaDataFactory dtoMetaDataFactory;

    public FetchResultSetHandler(Class<?> beanClass, BeanMetaData beanMetaData, DtoMetaDataFactory dtoMetaDataFactory) {
        this.beanClass = beanClass;
        this.beanMetaData = beanMetaData;
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    public Object handle(ResultSet resultSet) throws SQLException {
        FetchHandler<?> fetchHandler = this.getFetchHandler();
        ResultSetHandler resultSetHandler = this.createResultSetHandler(fetchHandler);
        return resultSetHandler.handle(resultSet);
    }

    protected ResultSetHandler createResultSetHandler(FetchHandler<?> fetchHandler) {
        Object resultSetHandler;
        Class<?> parameterClass = this.getParameterClass(fetchHandler);
        if (TypeUtil.isSimpleType(parameterClass)) {
            resultSetHandler = new FetchObjectResultSetHandler(parameterClass, fetchHandler);
        } else if (Map.class.isAssignableFrom(parameterClass)) {
            resultSetHandler = new FetchMapResultSetHandler(fetchHandler);
        } else if (!parameterClass.isAssignableFrom(this.beanClass)) {
            DtoMetaData dtoMetaData = this.dtoMetaDataFactory.getDtoMetaData(parameterClass);
            resultSetHandler = new FetchDtoMetaDataResultSetHandler(dtoMetaData, this.createRowCreator(), fetchHandler);
        } else {
            resultSetHandler = new FetchBeanMetaDataResultSetHandler(this.beanMetaData, this.createRowCreator(), this.createRelationRowCreator(), fetchHandler);
        }
        return resultSetHandler;
    }

    protected Class<?> getParameterClass(FetchHandler<?> fetchHandler) {
        Method[] methods;
        Class<?> clazz = null;
        for (Method method : methods = fetchHandler.getClass().getMethods()) {
            Class<?>[] c;
            if (!method.getName().equals("execute") || (c = method.getParameterTypes()).length != 1 || c[0].equals(Object.class)) continue;
            clazz = c[0];
            break;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("FetchHandler#execute is not found. (or argument is Object)");
        }
        return clazz;
    }

    protected FetchHandler<?> getFetchHandler() {
        Object[] args = PagerContext.getContext().peekArgs();
        if (args.length < 1 || !(args[args.length - 1] instanceof FetchHandler)) {
            throw new IllegalArgumentException("Last argument is not FetchHandler.");
        }
        return (FetchHandler)args[args.length - 1];
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }
}

