/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.handler;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.dao.ProcedureMetaData;
import org.seasar.dao.ProcedureParameterType;
import org.seasar.dao.handler.ProcedureHandler;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SIllegalArgumentException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class ArgumentDtoProcedureHandler
extends BasicSelectHandler
implements ProcedureHandler {
    private ProcedureMetaData procedureMetaData;

    public ProcedureMetaData getProcedureMetaData() {
        return this.procedureMetaData;
    }

    public void setProcedureMetaData(ProcedureMetaData procedureMetaData) {
        this.procedureMetaData = procedureMetaData;
    }

    public ArgumentDtoProcedureHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler, StatementFactory statementFactory, ResultSetFactory resultSetFactory, ProcedureMetaData procedureMetaData) {
        super(dataSource, sql, resultSetHandler, statementFactory, resultSetFactory);
        this.setProcedureMetaData(procedureMetaData);
    }

    public Object execute(Connection connection, Object[] args, Class[] argTypes) {
        Object dto = this.getArgumentDto(args);
        this.logSql(args, argTypes);
        CallableStatement cs = null;
        try {
            cs = this.prepareCallableStatement(connection);
            this.bindArgs(cs, dto);
            if (cs.execute()) {
                Object object = this.handleResultSet(cs);
                return object;
            }
            Object object = this.handleOutParameters(cs, dto);
            return object;
        }
        catch (SQLException e) {
            throw new SQLRuntimeException(e);
        }
        finally {
            StatementUtil.close((Statement)cs);
        }
    }

    protected String getCompleteSql(Object[] args) {
        String sql = this.getSql();
        Object dto = this.getArgumentDto(args);
        if (args == null || dto == null) {
            return sql;
        }
        StringBuffer buf = new StringBuffer(100);
        int pos = 0;
        int pos2 = 0;
        int size = this.procedureMetaData.getParameterTypeSize();
        for (int i = 0; i < size; ++i) {
            ProcedureParameterType ppt = this.procedureMetaData.getParameterType(i);
            pos2 = sql.indexOf(63, pos);
            if (pos2 < 0) break;
            buf.append(sql.substring(pos, pos2));
            pos = pos2 + 1;
            if (ppt.isInType()) {
                buf.append(this.getBindVariableText(ppt.getValue(dto)));
                continue;
            }
            buf.append(sql.substring(pos2, pos));
        }
        buf.append(sql.substring(pos));
        return buf.toString();
    }

    protected CallableStatement prepareCallableStatement(Connection connection) {
        if (this.getSql() == null) {
            throw new EmptyRuntimeException("sql");
        }
        CallableStatement cs = this.getStatementFactory().createCallableStatement(connection, this.getSql());
        if (this.getFetchSize() > -1) {
            StatementUtil.setFetchSize((Statement)cs, (int)this.getFetchSize());
        }
        if (this.getMaxRows() > -1) {
            StatementUtil.setMaxRows((Statement)cs, (int)this.getMaxRows());
        }
        return cs;
    }

    protected void bindArgs(CallableStatement cs, Object dto) throws SQLException {
        if (dto == null) {
            return;
        }
        int size = this.procedureMetaData.getParameterTypeSize();
        for (int i = 0; i < size; ++i) {
            ProcedureParameterType ppt = this.procedureMetaData.getParameterType(i);
            ValueType valueType = ppt.getValueType();
            if (ppt.isOutType()) {
                valueType.registerOutParameter(cs, i + 1);
            }
            if (!ppt.isInType()) continue;
            Object value = ppt.getValue(dto);
            valueType.bindValue((PreparedStatement)cs, i + 1, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResultSet(CallableStatement cs) throws SQLException {
        Object object;
        ResultSet rs = null;
        try {
            rs = this.getResultSetFactory().getResultSet((Statement)cs);
            object = this.getResultSetHandler().handle(rs);
        }
        catch (Throwable throwable) {
            ResultSetUtil.close(rs);
            throw throwable;
        }
        ResultSetUtil.close((ResultSet)rs);
        return object;
    }

    protected Object handleOutParameters(CallableStatement cs, Object dto) throws SQLException {
        if (dto == null) {
            return null;
        }
        int size = this.procedureMetaData.getParameterTypeSize();
        for (int i = 0; i < size; ++i) {
            ProcedureParameterType ppt = this.procedureMetaData.getParameterType(i);
            ValueType valueType = ppt.getValueType();
            if (!ppt.isOutType()) continue;
            Object value = valueType.getValue(cs, i + 1);
            ppt.setValue(dto, value);
        }
        return dto;
    }

    protected Object getArgumentDto(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        if (args.length == 1) {
            if (args[0] == null) {
                throw new SIllegalArgumentException("EDAO0029", new Object[0]);
            }
            return args[0];
        }
        throw new IllegalArgumentException("args");
    }
}

