/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.ResourceUtil;

public class ExcelIOUtil {
    private static Logger logger = Logger.getLogger((Class)ExcelIOUtil.class);

    public static Workbook getWorkbookNoResource(String fileName) {
        File file = new File(fileName);
        FileInputStream is = FileInputStreamUtil.create((File)file);
        Workbook workbook = ExcelIOUtil.getWorkbook(is);
        return workbook;
    }

    public static Workbook getWorkbook(String fileName) {
        URL resource = ResourceUtil.getResource((String)fileName);
        Workbook workbook = null;
        try {
            workbook = ExcelIOUtil.getWorkbook(resource.openStream());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return workbook;
    }

    private static Workbook getWorkbook(InputStream is) {
        Workbook workbook = null;
        try {
            workbook = Workbook.getWorkbook((InputStream)is);
        }
        catch (BiffException e) {
            logger.error((Object)e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return workbook;
    }

    public static Sheet getSheet(Workbook workbook, Object sheetInfo) {
        if (sheetInfo instanceof Number) {
            return ExcelIOUtil.getSheet(workbook, ((Number)sheetInfo).intValue());
        }
        return ExcelIOUtil.getSheet(workbook, sheetInfo.toString());
    }

    public static Sheet getSheet(Workbook workbook, int sheetNo) {
        return workbook.getSheet(sheetNo);
    }

    public static Sheet getSheet(Workbook workbook, String sheetName) {
        return workbook.getSheet(sheetName);
    }
}

