/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.buri.common.util.template.impl;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import org.seasar.buri.common.util.template.TextTemplate;
import org.seasar.buri.common.util.template.exception.TemplateRuntimeException;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamReaderUtil;
import org.seasar.framework.util.ReaderUtil;
import org.seasar.framework.util.ResourceUtil;

public class TextTemplateFreeMakerImpl
implements TextTemplate {
    private Configuration configuration = new Configuration();

    public String processResource(String resourceName, Object data) {
        URL resource = ResourceUtil.getResource((String)resourceName);
        try {
            return this.processInputStream(resource.openStream(), data);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public String processFile(String fileName, Object data) {
        File file = new File(fileName);
        FileInputStream is = FileInputStreamUtil.create((File)file);
        return this.processInputStream(is, data);
    }

    private String processInputStream(InputStream is, Object data) {
        InputStreamReader reader = InputStreamReaderUtil.create((InputStream)is);
        String templateText = ReaderUtil.readText((Reader)reader);
        return this.process(templateText, data);
    }

    public String process(String templateText, Object data) {
        Template template = null;
        try {
            template = new Template("name", (Reader)new StringReader(templateText), this.configuration);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        StringWriter stringWriter = new StringWriter();
        try {
            template.process(data, (Writer)stringWriter);
        }
        catch (TemplateException e) {
            throw new TemplateRuntimeException(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        stringWriter.flush();
        String result = stringWriter.toString();
        return result;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

