/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.dialect.postgresql;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.jiemamy.dialect.DefaultTokenResolver;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.sql.Keyword;
import org.jiemamy.model.sql.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSqlTokenResolver
extends DefaultTokenResolver {
    protected List<Token> resolveType(DataType type) {
        Validate.notNull((Object)type);
        Boolean serial = (Boolean)type.getParam(TypeParameterKey.SERIAL);
        if (serial != null && serial.booleanValue()) {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)5);
            if (type.getRawTypeDescriptor().getTypeName().equals("INTEGER")) {
                result.add(Keyword.of((String)"SERIAL"));
                return result;
            }
            if (type.getRawTypeDescriptor().getTypeName().equals("BIGINT")) {
                result.add(Keyword.of((String)"BIGSERIAL"));
                return result;
            }
        }
        return super.resolveType(type);
    }
}

