/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.validator.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.jiemamy.JiemamyContext;
import org.jiemamy.dddbase.Entity;
import org.jiemamy.dialect.Dialect;
import org.jiemamy.dialect.Necessity;
import org.jiemamy.model.column.JmColumn;
import org.jiemamy.model.datatype.DataType;
import org.jiemamy.model.datatype.SimpleRawTypeDescriptor;
import org.jiemamy.model.datatype.TypeParameterKey;
import org.jiemamy.model.table.JmTable;
import org.jiemamy.validator.AbstractProblem;
import org.jiemamy.validator.AbstractValidator;
import org.jiemamy.validator.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTypeValidator
extends AbstractValidator {
    public Collection<Problem> validate(JiemamyContext context) {
        ArrayList problems = Lists.newArrayList();
        Dialect dialect = null;
        try {
            dialect = context.findDialect();
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (JmTable table : context.getTables()) {
            for (JmColumn column : table.getColumns()) {
                DataType dataType = column.getDataType();
                if (dataType == null) continue;
                this.verify(dataType, dialect, table, column, problems);
            }
        }
        return problems;
    }

    private void verify(DataType dataType, Dialect dialect, JmTable table, JmColumn column, Collection<Problem> collector) {
        Validate.notNull((Object)dataType);
        Validate.notNull(collector);
        if (dataType.getRawTypeDescriptor() == SimpleRawTypeDescriptor.UNKNOWN) {
            collector.add(new UnknownDataTypeReferenceProblem(table, column));
        }
        if (dialect != null) {
            Map<TypeParameterKey<?>, Necessity> typeParameterSpecs = dialect.getTypeParameterSpecs(dataType.getRawTypeDescriptor());
            for (Map.Entry<TypeParameterKey<?>, Necessity> entry : typeParameterSpecs.entrySet()) {
                if (entry.getValue() != Necessity.REQUIRED || dataType.getParam(entry.getKey()) != null) continue;
                collector.add(new RequiredParameterNotFoundProblem(table, column));
            }
        }
    }

    static class UnknownDataTypeReferenceProblem
    extends AbstractProblem {
        public UnknownDataTypeReferenceProblem(JmTable table, JmColumn column) {
            super((Entity)column, "E0160", new Object[]{table.getName(), column.getName()});
        }
    }

    static class RequiredParameterNotFoundProblem
    extends AbstractProblem {
        RequiredParameterNotFoundProblem(JmTable table, JmColumn column) {
            super((Entity)column, "E0210", new Object[]{table.getName(), column.getName()});
        }
    }
}

