/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.collection;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMap<K, V>
extends HashMap<K, V> {
    private List<V> valueList = Lists.newArrayList();

    public ArrayMap() {
    }

    public ArrayMap(int capacity) {
        super(capacity);
        this.valueList = Lists.newArrayListWithCapacity((int)capacity);
    }

    public boolean contains(Object o) {
        return this.valueList.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.valueList.containsAll(c);
    }

    public V get(int index) {
        return this.valueList.get(index);
    }

    public int indexOf(Object o) {
        return this.valueList.indexOf(o);
    }

    public Iterator<V> iterator() {
        return this.valueList.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.valueList.lastIndexOf(o);
    }

    public ListIterator<V> listIterator() {
        return this.valueList.listIterator();
    }

    public ListIterator<V> listIterator(int index) {
        return this.valueList.listIterator(index);
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        this.valueList.add(value);
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        if (result != null) {
            this.valueList.remove(result);
        }
        return result;
    }

    public List<V> subList(int fromIndex, int toIndex) {
        return this.valueList.subList(fromIndex, toIndex);
    }

    public <T> T[] toArray() {
        return this.valueList.toArray();
    }

    public <T> T[] toArray(T[] values) {
        return this.valueList.toArray(values);
    }
}

