/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class ProcedureColumnsMeta {
    public final String procedureCat;
    public final String procedureSchem;
    public final String procedureName;
    public final String columnName;
    public final ColumnType columnType;
    public final int dataType;
    public final String typeName;
    public final int precision;
    public final int length;
    public final short scale;
    public final short radix;
    public final Nullable nullable;

    public ProcedureColumnsMeta(ResultSet procedureColumn) {
        Validate.notNull((Object)procedureColumn);
        this.procedureCat = ResultSetUtil.getValue(String.class, procedureColumn, "PROCEDURE_CAT", null);
        this.procedureSchem = ResultSetUtil.getValue(String.class, procedureColumn, "PROCEDURE_SCHEM", null);
        this.procedureName = ResultSetUtil.getValue(String.class, procedureColumn, "PROCEDURE_NAME", null);
        this.columnName = ResultSetUtil.getValue(String.class, procedureColumn, "COLUMN_NAME", null);
        this.columnType = ColumnType.getColumnType((Short)ResultSetUtil.getValue(Short.TYPE, procedureColumn, "COLUMN_TYPE", null));
        this.dataType = ResultSetUtil.getValue(Integer.TYPE, procedureColumn, "DATA_TYPE", Integer.valueOf(0));
        this.typeName = ResultSetUtil.getValue(String.class, procedureColumn, "TYPE_NAME", null);
        this.precision = ResultSetUtil.getValue(Integer.TYPE, procedureColumn, "PRECISION", Integer.valueOf(0));
        this.length = ResultSetUtil.getValue(Integer.TYPE, procedureColumn, "LENGTH", Integer.valueOf(0));
        this.scale = ResultSetUtil.getValue(Short.TYPE, procedureColumn, "SCALE", Short.valueOf((short)0));
        this.radix = ResultSetUtil.getValue(Short.TYPE, procedureColumn, "RADIX", Short.valueOf((short)0));
        this.nullable = Nullable.getNullable(ResultSetUtil.getValue(Short.TYPE, procedureColumn, "NULLABLE", Short.valueOf((short)0)));
        assert (this.procedureName != null);
        assert (this.columnName != null);
        assert (this.columnType != null);
        assert (this.typeName != null);
        assert (this.nullable != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nullable {
        NO_NULLS(0),
        NULLABLE(1),
        UNKNOWN(2);

        private final int value;

        private static Nullable getNullable(short value) {
            for (Nullable nullable : Nullable.values()) {
                if (nullable.value != value) continue;
                return nullable;
            }
            return null;
        }

        private Nullable(int value) {
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ColumnType {
        UNKNOWN(0),
        IN(1),
        INOUT(2),
        OUT(4),
        RETURN(5),
        RESULT(3);

        private int value;

        private static ColumnType getColumnType(short value) {
            for (ColumnType columnType : ColumnType.values()) {
                if (columnType.value != value) continue;
                return columnType;
            }
            return null;
        }

        private ColumnType(int value) {
            this.value = value;
        }
    }
}

