/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.reflect;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private static Map<Class<?>, Class<?>> wrapperToPrimitiveMap = new HashMap();
    private static Map<Class<?>, Class<?>> primitiveToWrapperMap = new HashMap();
    private static Map<String, Class<?>> primitiveClsssNameMap = new HashMap();

    public static String concatName(String s1, String s2) {
        if (StringUtils.isEmpty((String)s1) && StringUtils.isEmpty((String)s2)) {
            return s1;
        }
        if (!StringUtils.isEmpty((String)s1) && StringUtils.isEmpty((String)s2)) {
            return s1;
        }
        if (StringUtils.isEmpty((String)s1) && !StringUtils.isEmpty((String)s2)) {
            return s2;
        }
        return s1 + '.' + s2;
    }

    public static Class<?> convertClass(String className) throws ClassNotFoundException {
        Class<?> clazz = primitiveClsssNameMap.get(className);
        if (clazz != null) {
            return clazz;
        }
        return ClassUtil.forName(className);
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return Class.forName(className, true, loader);
    }

    public static Field getFieldNoException(Class<?> clazz, String fieldName) {
        Validate.notNull(clazz);
        try {
            return clazz.getField(fieldName);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static String getPackageName(Class<?> clazz) {
        Validate.notNull(clazz);
        String fqcn = clazz.getName();
        int pos = fqcn.lastIndexOf(46);
        if (pos > 0) {
            return fqcn.substring(0, pos);
        }
        return null;
    }

    public static String getResourcePath(Class<?> clazz) {
        Validate.notNull(clazz);
        return ClassUtil.getResourcePath(clazz.getName());
    }

    public static String getResourcePath(String className) {
        Validate.notNull((Object)className);
        return StringUtils.replace((String)className, (String)".", (String)"/") + ".class";
    }

    public static String getShortClassName(Class<?> clazz) {
        Validate.notNull(clazz);
        return ClassUtil.getShortClassName(clazz.getName());
    }

    public static String getShortClassName(String className) {
        Validate.notNull((Object)className);
        int i = className.lastIndexOf(46);
        if (i > 0) {
            return className.substring(i + 1);
        }
        return className;
    }

    public static String getSimpleClassName(Class<?> clazz) {
        Validate.notNull(clazz);
        if (clazz.isArray()) {
            return ClassUtil.getSimpleClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static boolean isAssignableFrom(Class<?> toClass, Class<?> fromClass) {
        Validate.notNull(toClass);
        Validate.notNull(fromClass);
        if (toClass == Object.class && !fromClass.isPrimitive()) {
            return true;
        }
        if (toClass.isPrimitive()) {
            fromClass = ClassUtil.toPrimitiveClassIfWrapper(fromClass);
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassUtil.forName(className).newInstance();
    }

    public static String[] splitPackageAndShortClassName(String className) {
        Validate.notNull((Object)className);
        String[] ret = new String[2];
        int i = className.lastIndexOf(46);
        if (i > 0) {
            ret[0] = className.substring(0, i);
            ret[1] = className.substring(i + 1);
        } else {
            ret[1] = className;
        }
        return ret;
    }

    public static Class<?> toPrimitiveClass(Class<?> clazz) {
        Validate.notNull(clazz);
        return wrapperToPrimitiveMap.get(clazz);
    }

    public static Class<?> toPrimitiveClassIfWrapper(Class<?> clazz) {
        Validate.notNull(clazz);
        Class<?> ret = ClassUtil.toPrimitiveClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    public static Class<?> toWrapperClass(Class<?> clazz) {
        Validate.notNull(clazz);
        return primitiveToWrapperMap.get(clazz);
    }

    public static Class<?> toWrapperClassIfPrimitive(Class<?> clazz) {
        Validate.notNull(clazz);
        Class<?> ret = ClassUtil.toWrapperClass(clazz);
        if (ret != null) {
            return ret;
        }
        return clazz;
    }

    private ClassUtil() {
    }

    static {
        wrapperToPrimitiveMap.put(Character.class, Character.TYPE);
        wrapperToPrimitiveMap.put(Byte.class, Byte.TYPE);
        wrapperToPrimitiveMap.put(Short.class, Short.TYPE);
        wrapperToPrimitiveMap.put(Integer.class, Integer.TYPE);
        wrapperToPrimitiveMap.put(Long.class, Long.TYPE);
        wrapperToPrimitiveMap.put(Double.class, Double.TYPE);
        wrapperToPrimitiveMap.put(Float.class, Float.TYPE);
        wrapperToPrimitiveMap.put(Boolean.class, Boolean.TYPE);
        primitiveToWrapperMap.put(Character.TYPE, Character.class);
        primitiveToWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveToWrapperMap.put(Short.TYPE, Short.class);
        primitiveToWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveToWrapperMap.put(Long.TYPE, Long.class);
        primitiveToWrapperMap.put(Double.TYPE, Double.class);
        primitiveToWrapperMap.put(Float.TYPE, Float.class);
        primitiveToWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveClsssNameMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveClsssNameMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveClsssNameMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveClsssNameMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveClsssNameMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveClsssNameMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveClsssNameMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveClsssNameMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
    }
}

