/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */

package org.seasar.codegen.sample.camel.condition;

import org.seasar.codegen.lib.Condition;
import org.seasar.codegen.lib.ConditionResult;
import org.seasar.codegen.lib.impl.ColumnImpl;
import org.seasar.codegen.lib.impl.ConditionResultImpl;
import org.seasar.dao.pager.DefaultPagerCondition;

/**
 * BuriBranchテーブルに対する検索条件です。
 * @author S2Dao-CodeGen
 */
public class BuribranchCondition extends DefaultPagerCondition implements Condition {

	private static final long serialVersionUID = 1L;

	private String alias;

	protected ConditionResult conditionResult;

	/**
	 * コンストラクタです。
	 * 
	 * @param alias 表の別名
	 * @param conditionResult 検索条件
	 */
	BuribranchCondition(ConditionResult conditionResult,String alias) {
		this.alias = alias;
		this.conditionResult = conditionResult;
	}

	/**
	 * コンストラクタです。表の別名はテーブル名になります。
	 */
	public BuribranchCondition() {
		this.alias = "BuriBranch";
		this.conditionResult = new ConditionResultImpl();
	}

	public ConditionResult getConditionResult() {
		return conditionResult;
	}


	/**
	 * BranchIDの検索条件を返します。
	 * @return BranchIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectBranchid() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"BranchID", getClass()));
	}


	/**
	 * parentBranchIDの検索条件を返します。
	 * @return parentBranchIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectParentbranchid() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"parentBranchID", getClass()));
	}


	/**
	 * PathIDの検索条件を返します。
	 * @return PathIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectPathid() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"PathID", getClass()));
	}


	/**
	 * DataIDの検索条件を返します。
	 * @return DataIDの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectDataid() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"DataID", getClass()));
	}


	/**
	 * processDateの検索条件を返します。
	 * @return processDateの検索条件
	 */
	public org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date> selectProcessdate() {
		return new org.seasar.codegen.lib.impl.DateConditionElementImpl<java.util.Date>(conditionResult, new ColumnImpl(this.alias,"processDate", getClass()));
	}


	/**
	 * versionNoの検索条件を返します。
	 * @return versionNoの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectVersionno() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"versionNo", getClass()));
	}


	/**
	 * countの検索条件を返します。
	 * @return countの検索条件
	 */
	public org.seasar.codegen.lib.impl.ConditionElementImpl<Long> selectEntity_count() {
		return new org.seasar.codegen.lib.impl.ConditionElementImpl<Long>(conditionResult, new ColumnImpl(this.alias,"count", getClass()));
	}



	public void addQuery(String query, Object... args) {
		conditionResult.addQuery(query, args);
	}

	@Override
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append(conditionResult.toString());
		sb.append("/offset=");
		sb.append(getOffset());
		sb.append("/limit=");
		sb.append(getLimit());
		return sb.toString();
	}

}
