/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.sql;

import org.apache.commons.lang.Validate;
import org.jiemamy.model.datatype.LiteralType;
import org.jiemamy.model.sql.Token;

public class Literal
implements Token {
    public static final Literal NULL = new Literal("NULL", LiteralType.NULL);
    public static final Literal TRUE = new Literal(true);
    public static final Literal FALSE = new Literal(false);
    private final String string;

    public static Literal of(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    public static Literal of(Number number) {
        if (number == null) {
            return NULL;
        }
        return new Literal(number);
    }

    public static Literal of(String string) {
        if (string == null) {
            return NULL;
        }
        return new Literal(string, LiteralType.CHARACTER);
    }

    public static Literal of(String string, LiteralType type) {
        if (string == null) {
            return NULL;
        }
        return new Literal(string, type);
    }

    protected Literal(String string, LiteralType type) {
        Validate.notNull((Object)string);
        this.string = type.convert(string);
    }

    Literal(boolean bool) {
        this(Boolean.valueOf(bool).toString(), LiteralType.BOOLEAN);
    }

    Literal(Number number) {
        this(number.toString(), LiteralType.NUMERIC);
    }

    public String toString() {
        return this.string;
    }
}

