/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils.sql.metadata;

import java.sql.ResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.jiemamy.utils.sql.ResultSetUtil;

public class AttributesMeta {
    public final String typeCat;
    public final String typeSchem;
    public final String typeName;
    public final String attrName;
    public final int dataType;
    public final String attrTypeName;
    public final int attrSize;
    public final int decimalDigits;
    public final int numPrecRadix;
    public final Nullable nullable;
    public final String remarks;
    public final String attrDef;
    public final int sqlDataType;
    public final int sqlDatetimeSub;
    public final int charOctetLength;
    public final int ordinalPosition;
    public final String isNullable;
    public final String scopeCatalog;
    public final String scopeSchema;
    public final String scopeTable;
    public final short sourceDataType;

    public AttributesMeta(ResultSet attribute) {
        Validate.notNull((Object)attribute);
        this.typeCat = ResultSetUtil.getValue(String.class, attribute, "TYPE_CAT", null);
        this.typeSchem = ResultSetUtil.getValue(String.class, attribute, "TYPE_SCHEM", null);
        this.typeName = ResultSetUtil.getValue(String.class, attribute, "TYPE_NAME", null);
        this.attrName = ResultSetUtil.getValue(String.class, attribute, "ATTR_NAME", null);
        this.dataType = ResultSetUtil.getValue(Integer.TYPE, attribute, "DATA_TYPE", Integer.valueOf(0));
        this.attrTypeName = ResultSetUtil.getValue(String.class, attribute, "ATTR_TYPE_NAME", null);
        this.attrSize = ResultSetUtil.getValue(Integer.TYPE, attribute, "ATTR_SIZE", Integer.valueOf(0));
        this.decimalDigits = ResultSetUtil.getValue(Integer.TYPE, attribute, "DECIMAL_DIGITS", Integer.valueOf(0));
        this.numPrecRadix = ResultSetUtil.getValue(Integer.TYPE, attribute, "NUM_PREC_RADIX", Integer.valueOf(0));
        this.nullable = Nullable.getNullable(ResultSetUtil.getValue(Integer.TYPE, attribute, "NULLABLE", Integer.valueOf(0)));
        this.remarks = ResultSetUtil.getValue(String.class, attribute, "REMARKS", null);
        this.attrDef = ResultSetUtil.getValue(String.class, attribute, "ATTR_DEF", null);
        this.sqlDataType = ResultSetUtil.getValue(Integer.TYPE, attribute, "SQL_DATA_TYPE", Integer.valueOf(0));
        this.sqlDatetimeSub = ResultSetUtil.getValue(Integer.TYPE, attribute, "SQL_DATETIME_SUB", Integer.valueOf(0));
        this.charOctetLength = ResultSetUtil.getValue(Integer.TYPE, attribute, "CHAR_OCTET_LENGTH", Integer.valueOf(0));
        this.ordinalPosition = ResultSetUtil.getValue(Integer.TYPE, attribute, "ORDINAL_POSITION", Integer.valueOf(0));
        this.isNullable = ResultSetUtil.getValue(String.class, attribute, "IS_NULLABLE", null);
        this.scopeCatalog = ResultSetUtil.getValue(String.class, attribute, "SCOPE_CATALOG", null);
        this.scopeSchema = ResultSetUtil.getValue(String.class, attribute, "SCOPE_SCHEMA", null);
        this.scopeTable = ResultSetUtil.getValue(String.class, attribute, "SCOPE_TABLE", null);
        this.sourceDataType = ResultSetUtil.getValue(Short.TYPE, attribute, "SOURCE_DATA_TYPE", Short.valueOf((short)0));
        assert (this.typeName != null);
        assert (this.attrName != null);
        assert (this.attrTypeName != null);
        assert (this.nullable != null);
        assert (this.isNullable != null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Nullable {
        NO_NULLS(0),
        NULLABLE(1),
        UNKNOWN(2);

        private final int value;

        private static Nullable getNullable(int value) {
            return ValueToEnum.get(value);
        }

        private Nullable(int value) {
            this.value = value;
        }

        private static class ValueToEnum {
            private static final Map<Integer, Nullable> REVERSE_DICTIONARY;

            static Nullable get(int key) {
                return REVERSE_DICTIONARY.get(key);
            }

            private ValueToEnum() {
            }

            static {
                HashMap<Integer, Nullable> map = new HashMap<Integer, Nullable>();
                for (Nullable elem : Nullable.values()) {
                    map.put(elem.value, elem);
                }
                REVERSE_DICTIONARY = Collections.unmodifiableMap(map);
            }
        }
    }
}

