/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.utils;

import java.beans.Introspector;
import java.util.LinkedList;
import org.apache.commons.lang.Validate;
import org.jiemamy.utils.Disposable;

public final class DisposableUtil {
    private static final LinkedList<Disposable> DISPOSABLES = new LinkedList();

    public static synchronized void add(Disposable disposable) {
        Validate.notNull((Object)disposable);
        DISPOSABLES.add(disposable);
    }

    public static synchronized void dispose() {
        while (!DISPOSABLES.isEmpty()) {
            Disposable disposable = DISPOSABLES.removeLast();
            try {
                disposable.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        DISPOSABLES.clear();
        Introspector.flushCaches();
    }

    public static synchronized void remove(Disposable disposable) {
        DISPOSABLES.remove(disposable);
    }

    private DisposableUtil() {
    }
}

