/*
 * Decompiled with CFR 0.152.
 */
package org.jiemamy.model.constraint;

import java.util.UUID;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang.Validate;
import org.codehaus.staxmate.in.SMEvent;
import org.jiemamy.model.constraint.SimpleJmCheckConstraint;
import org.jiemamy.model.constraint.SimpleJmDeferrability;
import org.jiemamy.serializer.SerializationException;
import org.jiemamy.serializer.stax.DeserializationContext;
import org.jiemamy.serializer.stax.JiemamyCursor;
import org.jiemamy.serializer.stax.JiemamyOutputContainer;
import org.jiemamy.serializer.stax.JiemamyOutputElement;
import org.jiemamy.serializer.stax.SerializationContext;
import org.jiemamy.serializer.stax.StaxDirector;
import org.jiemamy.serializer.stax.StaxHandler;
import org.jiemamy.xml.CoreQName;
import org.jiemamy.xml.JiemamyQName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJmCheckConstraintStaxHandler
extends StaxHandler<SimpleJmCheckConstraint> {
    private static Logger logger = LoggerFactory.getLogger(SimpleJmCheckConstraintStaxHandler.class);

    public SimpleJmCheckConstraintStaxHandler(StaxDirector director) {
        super(director);
    }

    @Override
    public SimpleJmCheckConstraint handleDeserialization(DeserializationContext dctx) throws SerializationException {
        Validate.notNull((Object)dctx);
        try {
            Validate.isTrue((dctx.peek().getCurrEvent() == SMEvent.START_ELEMENT ? 1 : 0) != 0);
            Validate.isTrue((boolean)dctx.peek().isQName(CoreQName.CHECK));
            JiemamyCursor cursor = dctx.peek();
            String idString = cursor.getAttrValue(CoreQName.ID);
            UUID id = dctx.getContext().toUUID(idString);
            SimpleJmCheckConstraint check = new SimpleJmCheckConstraint(id);
            JiemamyCursor childCursor = cursor.childElementCursor();
            dctx.push(childCursor);
            do {
                childCursor.advance();
                if (childCursor.getCurrEvent() == SMEvent.START_ELEMENT) {
                    if (childCursor.isQName(CoreQName.NAME)) {
                        check.setName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.LOGICAL_NAME)) {
                        check.setLogicalName(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DESCRIPTION)) {
                        check.setDescription(childCursor.collectDescendantText(false));
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.DEFERRABILITY)) {
                        SimpleJmDeferrability deferrability = (SimpleJmDeferrability)this.getDirector().direct(dctx);
                        check.setDeferrability(deferrability);
                        continue;
                    }
                    if (childCursor.isQName(CoreQName.EXPRESSION)) {
                        check.setExpression(childCursor.collectDescendantText(false));
                        continue;
                    }
                    logger.warn("UNKNOWN ELEMENT: {}", (Object)childCursor.getQName().toString());
                    continue;
                }
                if (childCursor.getCurrEvent() == null) continue;
                logger.warn("UNKNOWN EVENT: {}", (Object)childCursor.getCurrEvent());
            } while (childCursor.getCurrEvent() != null);
            dctx.pop();
            return check;
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void handleSerialization(SimpleJmCheckConstraint model, SerializationContext sctx) throws SerializationException {
        Validate.notNull((Object)model);
        Validate.notNull((Object)sctx);
        JiemamyOutputContainer parent = sctx.peek();
        try {
            JiemamyOutputElement element = parent.addElement(CoreQName.CHECK);
            element.addAttribute((JiemamyQName)CoreQName.ID, model.getId());
            element.addElementAndCharacters((JiemamyQName)CoreQName.NAME, model.getName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.LOGICAL_NAME, model.getLogicalName());
            element.addElementAndCharacters((JiemamyQName)CoreQName.DESCRIPTION, model.getDescription());
            sctx.push(element);
            if (model.getDeferrability() != null) {
                this.getDirector().direct(model.getDeferrability(), sctx);
            }
            sctx.pop();
            element.addElementAndCharacters((JiemamyQName)CoreQName.EXPRESSION, model.getExpression());
        }
        catch (XMLStreamException e) {
            throw new SerializationException(e);
        }
    }
}

