/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.parser;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.seasar.dao.CommandContext;
import org.seasar.dao.EndCommentNotFoundRuntimeException;
import org.seasar.dao.Node;
import org.seasar.dao.TokenNotClosedRuntimeException;
import org.seasar.dao.context.CommandContextImpl;
import org.seasar.dao.node.BindVariableNode;
import org.seasar.dao.node.IfNode;
import org.seasar.dao.node.SqlNode;
import org.seasar.dao.parser.SqlParserImpl;

public class SqlParserImplTest
extends TestCase {
    public SqlParserImplTest(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)SqlParserImplTest.class);
    }

    public void testParse() throws Exception {
        String sql = "SELECT * FROM emp";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Node node = parser.parse();
        node.accept((CommandContext)ctx);
        SqlParserImplTest.assertEquals((String)"1", (String)sql, (String)ctx.getSql());
    }

    public void testParseEndSemicolon() throws Exception {
        this.testParseEndSemicolon(";");
        this.testParseEndSemicolon(";\t");
        this.testParseEndSemicolon("; ");
    }

    private void testParseEndSemicolon(String endChar) {
        String sql = "SELECT * FROM emp";
        SqlParserImpl parser = new SqlParserImpl(sql + endChar);
        CommandContextImpl ctx = new CommandContextImpl();
        Node node = parser.parse();
        node.accept((CommandContext)ctx);
        SqlParserImplTest.assertEquals((String)"1", (String)sql, (String)ctx.getSql());
    }

    public void testCommentEndNotFound() throws Exception {
        String sql = "SELECT * FROM emp/*hoge";
        SqlParserImpl parser = new SqlParserImpl(sql);
        try {
            parser.parse();
            SqlParserImplTest.fail((String)"1");
        }
        catch (TokenNotClosedRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testParseBindVariable4() throws Exception {
        String sql = "SELECT * FROM emp WHERE job = #*job*#'CLERK' AND deptno = #*deptno*#20";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        String job = "CLERK";
        Integer deptno = new Integer(20);
        ctx.addArg("job", (Object)job, job.getClass());
        ctx.addArg("deptno", (Object)deptno, deptno.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
    }

    public void testParseBindVariable() throws Exception {
        String sql = "SELECT * FROM emp WHERE job = /*job*/'CLERK' AND deptno = /*deptno*/20";
        String sql2 = "SELECT * FROM emp WHERE job = ? AND deptno = ?";
        String sql3 = "SELECT * FROM emp WHERE job = ";
        String sql4 = " AND deptno = ";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        String job = "CLERK";
        Integer deptno = new Integer(20);
        ctx.addArg("job", (Object)job, job.getClass());
        ctx.addArg("deptno", (Object)deptno, deptno.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)2, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)job, (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (Object)deptno, (Object)vars[1]);
        SqlParserImplTest.assertEquals((String)"5", (int)4, (int)root.getChildSize());
        SqlNode sqlNode = (SqlNode)root.getChild(0);
        SqlParserImplTest.assertEquals((String)"6", (String)sql3, (String)sqlNode.getSql());
        BindVariableNode varNode = (BindVariableNode)root.getChild(1);
        SqlParserImplTest.assertEquals((String)"7", (String)"job", (String)varNode.getExpression());
        SqlNode sqlNode2 = (SqlNode)root.getChild(2);
        SqlParserImplTest.assertEquals((String)"8", (String)sql4, (String)sqlNode2.getSql());
        BindVariableNode varNode2 = (BindVariableNode)root.getChild(3);
        SqlParserImplTest.assertEquals((String)"9", (String)"deptno", (String)varNode2.getExpression());
    }

    public void testParseBindVariable2() throws Exception {
        String sql = "SELECT * FROM emp WHERE job = /* job*/'CLERK'";
        String sql3 = "SELECT * FROM emp WHERE job = ";
        String sql4 = "'CLERK'";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql, (String)ctx.getSql());
        SqlParserImplTest.assertEquals((String)"2", (int)3, (int)root.getChildSize());
        SqlNode sqlNode = (SqlNode)root.getChild(0);
        SqlParserImplTest.assertEquals((String)"3", (String)sql3, (String)sqlNode.getSql());
        SqlNode sqlNode2 = (SqlNode)root.getChild(2);
        SqlParserImplTest.assertEquals((String)"4", (String)sql4, (String)sqlNode2.getSql());
    }

    public void testParseWhiteSpace() throws Exception {
        String sql = "SELECT * FROM emp WHERE empno = /*empno*/1 AND 1 = 1";
        String sql2 = "SELECT * FROM emp WHERE empno = ? AND 1 = 1";
        String sql3 = " AND 1 = 1";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Integer empno = new Integer(7788);
        ctx.addArg("empno", (Object)empno, empno.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        SqlNode sqlNode = (SqlNode)root.getChild(2);
        SqlParserImplTest.assertEquals((String)"2", (String)sql3, (String)sqlNode.getSql());
    }

    public void testParseIf() throws Exception {
        String sql = "SELECT * FROM emp/*IF job != null*/ WHERE job = /*job*/'CLERK'/*END*/";
        String sql2 = "SELECT * FROM emp WHERE job = ?";
        String sql3 = "SELECT * FROM emp";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        String job = "CLERK";
        ctx.addArg("job", (Object)job, job.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)1, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)job, (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (int)2, (int)root.getChildSize());
        SqlNode sqlNode = (SqlNode)root.getChild(0);
        SqlParserImplTest.assertEquals((String)"5", (String)sql3, (String)sqlNode.getSql());
        IfNode ifNode = (IfNode)root.getChild(1);
        SqlParserImplTest.assertEquals((String)"6", (String)"job != null", (String)ifNode.getExpression());
        SqlParserImplTest.assertEquals((String)"7", (int)2, (int)ifNode.getChildSize());
        SqlNode sqlNode2 = (SqlNode)ifNode.getChild(0);
        SqlParserImplTest.assertEquals((String)"8", (String)" WHERE job = ", (String)sqlNode2.getSql());
        BindVariableNode varNode = (BindVariableNode)ifNode.getChild(1);
        SqlParserImplTest.assertEquals((String)"9", (String)"job", (String)varNode.getExpression());
        CommandContextImpl ctx2 = new CommandContextImpl();
        root.accept((CommandContext)ctx2);
        System.out.println(ctx2.getSql());
        SqlParserImplTest.assertEquals((String)"10", (String)sql3, (String)ctx2.getSql());
    }

    public void testParseIf2() throws Exception {
        String sql = "/*IF aaa != null*/aaa/*IF bbb != null*/bbb/*END*//*END*/";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"1", (String)"", (String)ctx.getSql());
        ctx.addArg("aaa", null, String.class);
        ctx.addArg("bbb", (Object)"hoge", String.class);
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"2", (String)"", (String)ctx.getSql());
        ctx.addArg("aaa", (Object)"hoge", String.class);
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"3", (String)"aaabbb", (String)ctx.getSql());
        CommandContextImpl ctx2 = new CommandContextImpl();
        ctx2.addArg("aaa", (Object)"hoge", String.class);
        ctx2.addArg("bbb", null, String.class);
        root.accept((CommandContext)ctx2);
        System.out.println("[" + ctx2.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"4", (String)"aaa", (String)ctx2.getSql());
    }

    public void testParseElse() throws Exception {
        String sql = "SELECT * FROM emp WHERE /*IF job != null*/job = /*job*/'CLERK'-- ELSE job is null/*END*/";
        String sql2 = "SELECT * FROM emp WHERE job = ?";
        String sql3 = "SELECT * FROM emp WHERE job is null";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        String job = "CLERK";
        ctx.addArg("job", (Object)job, job.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)1, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)job, (Object)vars[0]);
        CommandContextImpl ctx2 = new CommandContextImpl();
        root.accept((CommandContext)ctx2);
        System.out.println("[" + ctx2.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"4", (String)sql3, (String)ctx2.getSql());
    }

    public void testParseElse2() throws Exception {
        String sql = "/*IF false*/aaa--ELSE bbb = /*bbb*/123/*END*/";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Integer bbb = new Integer(123);
        ctx.addArg("bbb", (Object)bbb, bbb.getClass());
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"1", (String)"bbb = ?", (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)1, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)bbb, (Object)vars[0]);
    }

    public void testParseElse3() throws Exception {
        String sql = "/*IF false*/aaa--ELSE bbb/*IF false*/ccc--ELSE ddd/*END*//*END*/";
        SqlParserImpl parser = new SqlParserImpl(sql);
        CommandContextImpl ctx = new CommandContextImpl();
        Node root = parser.parse();
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"1", (String)"bbbddd", (String)ctx.getSql());
    }

    public void testElse4() throws Exception {
        String sql = "SELECT * FROM emp/*BEGIN*/ WHERE /*IF false*/aaa-- ELSE AND deptno = 10/*END*//*END*/";
        String sql2 = "SELECT * FROM emp WHERE deptno = 10";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
    }

    public void testBegin() throws Exception {
        String sql = "SELECT * FROM emp/*BEGIN*/ WHERE /*IF job != null*/job = /*job*/'CLERK'/*END*//*IF deptno != null*/ AND deptno = /*deptno*/20/*END*//*END*/";
        String sql2 = "SELECT * FROM emp";
        String sql3 = "SELECT * FROM emp WHERE job = ?";
        String sql4 = "SELECT * FROM emp WHERE job = ? AND deptno = ?";
        String sql5 = "SELECT * FROM emp WHERE deptno = ?";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        CommandContextImpl ctx2 = new CommandContextImpl();
        ctx2.addArg("job", (Object)"CLERK", String.class);
        ctx2.addArg("deptno", null, Integer.class);
        root.accept((CommandContext)ctx2);
        System.out.println(ctx2.getSql());
        SqlParserImplTest.assertEquals((String)"2", (String)sql3, (String)ctx2.getSql());
        CommandContextImpl ctx3 = new CommandContextImpl();
        ctx3.addArg("job", (Object)"CLERK", String.class);
        ctx3.addArg("deptno", (Object)new Integer(20), Integer.class);
        root.accept((CommandContext)ctx3);
        System.out.println(ctx3.getSql());
        SqlParserImplTest.assertEquals((String)"3", (String)sql4, (String)ctx3.getSql());
        CommandContextImpl ctx4 = new CommandContextImpl();
        ctx4.addArg("deptno", (Object)new Integer(20), Integer.class);
        ctx4.addArg("job", null, String.class);
        root.accept((CommandContext)ctx4);
        System.out.println(ctx4.getSql());
        SqlParserImplTest.assertEquals((String)"4", (String)sql5, (String)ctx4.getSql());
    }

    public void testBeginAnd() throws Exception {
        String sql = "/*BEGIN*/WHERE /*IF true*/aaa BETWEEN /*bbb*/111 AND /*ccc*/123/*END*//*END*/";
        String sql2 = "WHERE aaa BETWEEN ? AND ?";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        ctx.addArg("bbb", (Object)"111", String.class);
        ctx.addArg("ccc", (Object)"222", String.class);
        root.accept((CommandContext)ctx);
        System.out.println("[" + ctx.getSql() + "]");
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
    }

    public void testIn() throws Exception {
        String sql = "SELECT * FROM emp WHERE deptno IN /*deptnoList*/(10, 20) ORDER BY ename";
        String sql2 = "SELECT * FROM emp WHERE deptno IN (?, ?) ORDER BY ename";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        ArrayList<Integer> deptnoList = new ArrayList<Integer>();
        deptnoList.add(new Integer(10));
        deptnoList.add(new Integer(20));
        ctx.addArg("deptnoList", deptnoList, List.class);
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)2, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)new Integer(10), (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (Object)new Integer(20), (Object)vars[1]);
    }

    public void testIn2() throws Exception {
        String sql = "SELECT * FROM emp WHERE deptno IN /*deptnoList*/(10, 20) ORDER BY ename";
        String sql2 = "SELECT * FROM emp WHERE deptno IN (?, ?) ORDER BY ename";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        int[] deptnoArray = new int[]{10, 20};
        ctx.addArg("deptnoList", (Object)deptnoArray, deptnoArray.getClass());
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)2, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)new Integer(10), (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (Object)new Integer(20), (Object)vars[1]);
    }

    public void testIn3() throws Exception {
        String sql = "SELECT * FROM emp WHERE ename IN /*enames*/('SCOTT','MARY') AND job IN /*jobs*/('ANALYST', 'FREE')";
        String sql2 = "SELECT * FROM emp WHERE ename IN (?, ?) AND job IN (?, ?)";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        String[] enames = new String[]{"SCOTT", "MARY"};
        String[] jobs = new String[]{"ANALYST", "FREE"};
        ctx.addArg("enames", (Object)enames, enames.getClass());
        ctx.addArg("jobs", (Object)jobs, jobs.getClass());
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql2, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)4, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)"SCOTT", (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (Object)"MARY", (Object)vars[1]);
        SqlParserImplTest.assertEquals((String)"5", (Object)"ANALYST", (Object)vars[2]);
        SqlParserImplTest.assertEquals((String)"6", (Object)"FREE", (Object)vars[3]);
    }

    public void testParseBindVariable3() throws Exception {
        String sql = "BETWEEN sal ? AND ?";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        ctx.addArg("$1", (Object)new Integer(0), Integer.class);
        ctx.addArg("$2", (Object)new Integer(1000), Integer.class);
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)sql, (String)ctx.getSql());
        Object[] vars = ctx.getBindVariables();
        SqlParserImplTest.assertEquals((String)"2", (int)2, (int)vars.length);
        SqlParserImplTest.assertEquals((String)"3", (Object)new Integer(0), (Object)vars[0]);
        SqlParserImplTest.assertEquals((String)"4", (Object)new Integer(1000), (Object)vars[1]);
    }

    public void testEndNotFound() throws Exception {
        String sql = "/*BEGIN*/";
        SqlParserImpl parser = new SqlParserImpl(sql);
        try {
            parser.parse();
            SqlParserImplTest.fail((String)"1");
        }
        catch (EndCommentNotFoundRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testEndParent() throws Exception {
        String sql = "INSERT INTO ITEM (ID, NUM) VALUES (/*id*/1, /*num*/20)";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        ctx.addArg("id", (Object)new Integer(0), Integer.class);
        ctx.addArg("num", (Object)new Integer(1), Integer.class);
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (boolean)true, (boolean)ctx.getSql().endsWith(")"));
    }

    public void testEmbeddedValue() throws Exception {
        String sql = "/*$aaa*/";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        ctx.addArg("aaa", (Object)new Integer(0), Integer.class);
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"1", (String)"0", (String)ctx.getSql());
    }

    public void testCommentAlive() throws Exception {
        String sql = "SELECT AAA,BBB -- UGO \r\nFROM HOGE WHERE AAA=/*moge*/aaa AND FUGA=/* PIRO */ccc";
        SqlParserImpl parser = new SqlParserImpl(sql);
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA,BBB -- UGO \nFROM HOGE WHERE AAA=? AND FUGA=/* PIRO */ccc", (String)ctx.getSql());
    }

    public void testCommentAlive2() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT /*+ INDEX(TABLE_NAME INDEX_NAME) */ AAA FROM HOGE");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        SqlParserImplTest.assertEquals((String)"SELECT /*+ INDEX(TABLE_NAME INDEX_NAME) */ AAA FROM HOGE", (String)ctx.getSql());
    }

    public void testDeleteQuestion() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT AAA \r\n--comment? \r\n--comment2? \r\nFROM HOGE");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA \n--comment \n--comment2 \nFROM HOGE", (String)ctx.getSql());
    }

    public void testDeleteQuestion2() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT AAA \r--comment? \r--comment2? \rFROM HOGE");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA \n--comment \n--comment2 \nFROM HOGE", (String)ctx.getSql());
    }

    public void testDeleteQuestion3() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT AAA \n--comment? \n--comment2? \nFROM HOGE");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA \n--comment \n--comment2 \nFROM HOGE", (String)ctx.getSql());
    }

    public void testDeleteQuestion4() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT AAA FROM HOGE where /*IF hoge != null */ aa = /*fuga*/gaga --ELSE bb = ? /*END*/ /* comment? */");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA FROM HOGE where bb = ?  /* comment */", (String)ctx.getSql());
    }

    public void testDeleteQuestion5() throws Exception {
        SqlParserImpl parser = new SqlParserImpl("SELECT AAA FROM HOGE where aa = ?  -- comment?");
        Node root = parser.parse();
        CommandContextImpl ctx = new CommandContextImpl();
        root.accept((CommandContext)ctx);
        System.out.println(ctx.getSql());
        SqlParserImplTest.assertEquals((String)"SELECT AAA FROM HOGE where aa = ?  -- comment", (String)ctx.getSql());
    }
}

