/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import java.sql.ResultSet;
import junit.framework.TestCase;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.MockResultSetFactory;
import org.seasar.dao.pager.PagerContext;
import org.seasar.dao.pager.PagerResultSetFactoryWrapper;
import org.seasar.dao.pager.PagerResultSetWrapper;
import org.seasar.extension.jdbc.ResultSetFactory;

public class PagerResultSetFactoryWapperTest
extends TestCase {
    MockResultSetFactory original;
    PagerResultSetFactoryWrapper wrapper;

    protected void setUp() throws Exception {
        super.setUp();
        this.original = new MockResultSetFactory();
        this.wrapper = new PagerResultSetFactoryWrapper((ResultSetFactory)this.original);
        PagerContext.start();
    }

    protected void tearDown() throws Exception {
        PagerContext.end();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateResultSetNotPagerCondition() throws Exception {
        try {
            PagerContext.getContext().pushArgs(this.createNormalArgs());
            ResultSet resultSet = this.wrapper.createResultSet(null);
            PagerResultSetFactoryWapperTest.assertEquals((int)1, (int)this.original.getCreatedResultSetCount());
            PagerResultSetFactoryWapperTest.assertEquals((Object)this.original.getCreatedResultSet(0), (Object)resultSet);
        }
        finally {
            PagerContext.getContext().popArgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateResultSetPagerCondition() throws Exception {
        try {
            PagerContext.getContext().pushArgs(this.createPagerConditionArgs());
            ResultSet resultSet = this.wrapper.createResultSet(null);
            PagerResultSetFactoryWapperTest.assertEquals((int)1, (int)this.original.getCreatedResultSetCount());
            PagerResultSetFactoryWapperTest.assertEquals((Object)PagerResultSetWrapper.class, resultSet.getClass());
        }
        finally {
            PagerContext.getContext().popArgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateResultSetPagerConditionNoneLimit() throws Exception {
        try {
            PagerContext.getContext().pushArgs(this.createPagerConditionArgsNoneLimit());
            ResultSet resultSet = this.wrapper.createResultSet(null);
            PagerResultSetFactoryWapperTest.assertEquals((int)1, (int)this.original.getCreatedResultSetCount());
            PagerResultSetFactoryWapperTest.assertEquals((Object)this.original.getCreatedResultSet(0), (Object)resultSet);
        }
        finally {
            PagerContext.getContext().popArgs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateResultSetSequence() throws Exception {
        try {
            PagerContext.getContext().pushArgs(this.createPagerConditionArgs());
            PagerContext.getContext().pushArgs(this.createNormalArgs());
            ResultSet resultSet = this.wrapper.createResultSet(null);
            PagerResultSetFactoryWapperTest.assertEquals((int)1, (int)this.original.getCreatedResultSetCount());
            PagerResultSetFactoryWapperTest.assertEquals((Object)this.original.getCreatedResultSet(0), (Object)resultSet);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            PagerContext.getContext().popArgs();
            try {
                ResultSet resultSet = this.wrapper.createResultSet(null);
                PagerResultSetFactoryWapperTest.assertEquals((int)2, (int)this.original.getCreatedResultSetCount());
                PagerResultSetFactoryWapperTest.assertEquals((Object)PagerResultSetWrapper.class, resultSet.getClass());
            }
            finally {
                PagerContext.getContext().popArgs();
            }
            throw throwable;
        }
        PagerContext.getContext().popArgs();
        try {
            ResultSet resultSet = this.wrapper.createResultSet(null);
            PagerResultSetFactoryWapperTest.assertEquals((int)2, (int)this.original.getCreatedResultSetCount());
            PagerResultSetFactoryWapperTest.assertEquals((Object)PagerResultSetWrapper.class, resultSet.getClass());
        }
        finally {
            PagerContext.getContext().popArgs();
        }
    }

    private Object[] createNormalArgs() {
        return new Object[0];
    }

    private Object[] createPagerConditionArgs() {
        DefaultPagerCondition pagerConditionBase = new DefaultPagerCondition();
        pagerConditionBase.setLimit(10);
        return new Object[]{pagerConditionBase};
    }

    private Object[] createPagerConditionArgsNoneLimit() {
        DefaultPagerCondition pagerConditionBase = new DefaultPagerCondition();
        pagerConditionBase.setLimit(-1);
        return new Object[]{pagerConditionBase};
    }
}

