/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import junit.framework.TestCase;
import org.seasar.dao.pager.DefaultPagerCondition;
import org.seasar.dao.pager.PagerCondition;
import org.seasar.dao.pager.PagerViewHelper;

public class PagerConditionBaseTest
extends TestCase {
    DefaultPagerCondition condition;

    protected void setUp() throws Exception {
        this.condition = new DefaultPagerCondition();
    }

    public void testFirstPage() {
        this.setCondtion(0, 10, 95);
        this.assertCondtion(false, true, 0, 1, 0, 10, 9, 9);
    }

    public void testSecondPage() {
        this.setCondtion(10, 10, 95);
        this.assertCondtion(true, true, 1, 2, 0, 20, 19, 9);
    }

    public void testLastPage() {
        this.setCondtion(90, 10, 95);
        this.assertCondtion(true, false, 9, 10, 80, 100, 94, 9);
    }

    public void testEmptyResult() {
        this.setCondtion(0, 10, 0);
        this.assertCondtion(false, false, 0, 1, 0, 10, 0, 0);
    }

    public void test9Result() {
        this.setCondtion(0, 10, 9);
        this.assertCondtion(false, false, 0, 1, 0, 10, 8, 0);
    }

    public void test10Result() {
        this.setCondtion(0, 10, 10);
        this.assertCondtion(false, false, 0, 1, 0, 10, 9, 0);
    }

    private void assertCondtion(boolean isPrev, boolean isNext, int pageIndex, int pageCount, int prevOffset, int nextOffset, int currentLastOffset, int lastPageIndex) {
        PagerViewHelper helper = new PagerViewHelper((PagerCondition)this.condition);
        PagerConditionBaseTest.assertEquals((boolean)isPrev, (boolean)helper.isPrev());
        PagerConditionBaseTest.assertEquals((boolean)isNext, (boolean)helper.isNext());
        PagerConditionBaseTest.assertEquals((int)pageIndex, (int)helper.getPageIndex());
        PagerConditionBaseTest.assertEquals((int)pageCount, (int)helper.getPageCount());
        PagerConditionBaseTest.assertEquals((int)prevOffset, (int)helper.getPrevOffset());
        PagerConditionBaseTest.assertEquals((int)nextOffset, (int)helper.getNextOffset());
        PagerConditionBaseTest.assertEquals((int)currentLastOffset, (int)helper.getCurrentLastOffset());
        PagerConditionBaseTest.assertEquals((int)lastPageIndex, (int)helper.getLastPageIndex());
    }

    private void setCondtion(int offset, int limit, int count) {
        this.condition.setOffset(offset);
        this.condition.setLimit(limit);
        this.condition.setCount(count);
    }
}

