/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import junit.framework.TestCase;
import org.seasar.dao.pager.OracleRownumPagingSqlRewriter;

public class OracleRownumPagingSqlRewriterTest
extends TestCase {
    OracleRownumPagingSqlRewriter rewriter;

    protected void setUp() throws Exception {
        super.setUp();
        this.rewriter = new OracleRownumPagingSqlRewriter();
    }

    public void testMakeCountSql() {
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT)", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(ORDER BY \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT ORDER BY id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(whitespace\u4ed8\u304dorder by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT\n)", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT\norder by\n    id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name like '%order by%' )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE name like '%order by%' order by id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/)", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE name='aaa'/*order by*/order by id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(\u9014\u4e2d\u306eorder by\u306f\u9664\u53bb\u3057\u306a\u3044)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\n)", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT WHERE\n--order by\nname=1\norder by id"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \uff2e\uff2f"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb UNICODE)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d, \u7d44\u7e54_ID"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by \u540d\u524d ASC\n, \u7d44\u7e54_ID DESC"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb ASC,DESC+\u7a7a\u884c)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order\n\tby\n\n \u540d\u524d \n\tASC \n\n\n, \u7d44\u7e54_ID \n\tDESC \n"));
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(order by\u9664\u53bb Order by\u306e\u30ab\u30f3\u30de\u306e\u524d\u306b\u7a7a\u767d)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by aaa , bbb , ccc"));
    }

    public void testSetChopOrderByAndMakeCountSql() throws Exception {
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=true, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT )", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
        this.rewriter.setChopOrderBy(false);
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"count(*)\u3067\u5168\u4ef6\u6570\u3092\u53d6\u5f97\u3059\u308bSQL\u3092\u751f\u6210(chopOrderBy=false, order by \u9664\u53bb)", (String)"SELECT count(*) FROM (SELECT * FROM DEPARTMENT order by id)", (String)this.rewriter.makeCountSql("SELECT * FROM DEPARTMENT order by id"));
    }

    public void testMakeCountSql_orderbyClauseInSubquery() throws Exception {
        String actual = this.rewriter.makeCountSql("SELECT * FROM (SELECT * FROM EMPLOYEE E ORDER BY E.EMPLOYEE_NAME ASC, E.EMPLOYEE_ID DESC, E.EMPLOYEE_HIREDATE ASC)");
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"SELECT count(*) FROM (SELECT * FROM (SELECT * FROM EMPLOYEE E ORDER BY E.EMPLOYEE_NAME ASC, E.EMPLOYEE_ID DESC, E.EMPLOYEE_HIREDATE ASC))", (String)actual);
    }

    public void testLimitOffsetSql() throws Exception {
        OracleRownumPagingSqlRewriterTest.assertEquals((String)"\u6307\u5b9a\u3055\u308c\u305flimit offset\u304c\u4ed8\u52a0\u3055\u308c\u305fSQL\u3092\u751f\u6210", (String)"SELECT * FROM (SELECT S2DAO_ORIGINAL_DATA.*, ROWNUM AS S2DAO_ROWNUMBER FROM (SELECT * FROM DEPARTMENT) S2DAO_ORIGINAL_DATA) WHERE S2DAO_ROWNUMBER BETWEEN 56 AND 65 AND ROWNUM <= 10 ORDER BY S2DAO_ROWNUMBER", (String)this.rewriter.makeLimitOffsetSql("SELECT * FROM DEPARTMENT", 10, 55));
    }
}

