/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.interceptors;

import java.util.List;
import junit.textui.TestRunner;
import org.seasar.dao.interceptors.Employee;
import org.seasar.dao.interceptors.EmployeeAutoDao;
import org.seasar.extension.unit.S2TestCase;

public class S2DaoInterceptor2Test
extends S2TestCase {
    private EmployeeAutoDao dao;

    public S2DaoInterceptor2Test(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)S2DaoInterceptor2Test.class);
    }

    public void setUp() {
        this.include("EmployeeAutoDao.dicon");
    }

    public void testInsertTx() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("hoge");
        S2DaoInterceptor2Test.assertEquals((String)"1", (int)1, (int)this.dao.insert(emp));
    }

    public void testSelect() throws Exception {
        Employee emp = this.dao.getEmployee(7788);
        System.out.println(emp);
        S2DaoInterceptor2Test.assertEquals((String)"1", (long)7788L, (long)emp.getEmpno());
    }

    public void testSelectQuery() throws Exception {
        List employees = this.dao.getEmployeesBySal(0.0f, 1000.0f);
        System.out.println(employees);
        S2DaoInterceptor2Test.assertEquals((String)"1", (int)2, (int)employees.size());
    }

    public void testInsertBatchTx() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("hoge");
        Employee emp2 = new Employee();
        emp2.setEmpno(98L);
        emp2.setEname("hoge2");
        S2DaoInterceptor2Test.assertEquals((String)"1", (int)2, (int)this.dao.insertBatch(new Employee[]{emp, emp2}));
    }

    public void testFullWidthTildaTx() throws Exception {
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("\uff5e");
        this.dao.insert(emp);
        Employee emp2 = this.dao.getEmployee(99);
        S2DaoInterceptor2Test.assertEquals((String)"1", (String)emp.getEname(), (String)emp2.getEname());
    }
}

