/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeAutoDao;
import org.seasar.dao.unit.S2DaoTestCase;

public class UpdateBatchAutoStaticCommandTest
extends S2DaoTestCase {
    public void testExecuteTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("updateBatch");
        Employee emp = new Employee();
        emp.setEmpno(7499L);
        emp.setEname("hoge");
        emp.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        Employee emp2 = new Employee();
        emp2.setEmpno(7369L);
        emp2.setEname("hoge2");
        emp2.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        Integer count = (Integer)cmd.execute(new Object[]{new Employee[]{emp, emp2}});
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(2), (Object)count);
        SqlCommand cmd2 = dmd.getSqlCommand("updateBatch2");
        Employee emp3 = new Employee();
        emp3.setEmpno(7782L);
        emp3.setEname("hoge");
        emp3.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        Employee emp4 = new Employee();
        emp4.setEmpno(7788L);
        emp4.setEname("hoge2");
        emp4.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        int[] ret = (int[])cmd2.execute(new Object[]{new Employee[]{emp3, emp4}});
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"2", (int)2, (int)ret.length);
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"3", (int)1, (int)ret[0]);
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"4", (int)0, (int)ret[1]);
    }

    public void testExecuteByListTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("updateBatchByList");
        ArrayList<Employee> list = new ArrayList<Employee>();
        Employee emp = new Employee();
        emp.setEmpno(7499L);
        emp.setEname("hoge");
        emp.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        list.add(emp);
        emp = new Employee();
        emp.setEmpno(7369L);
        emp.setEname("hoge2");
        emp.setTimestamp(Timestamp.valueOf("2000-01-01 00:00:00.0"));
        list.add(emp);
        Integer count = (Integer)cmd.execute(new Object[]{list});
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(2), (Object)count);
        cmd = dmd.getSqlCommand("getEmployee");
        Employee employee = (Employee)cmd.execute(new Object[]{new Integer(7499)});
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"hoge", (String)employee.getEname());
        employee = (Employee)cmd.execute(new Object[]{new Integer(7369)});
        UpdateBatchAutoStaticCommandTest.assertEquals((String)"hoge2", (String)employee.getEname());
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

