/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.NoUpdatePropertyTypeRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Department;
import org.seasar.dao.impl.DepartmentAutoDao;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeAutoDao;
import org.seasar.dao.impl.UpdateAutoDynamicCommand;
import org.seasar.dao.unit.S2DaoTestCase;

public class UpdateAutoDynamicCommandTest
extends S2DaoTestCase {
    static /* synthetic */ Class class$org$seasar$dao$impl$UpdateAutoDynamicCommandTest$CharTable;

    protected void setUp() throws Exception {
        super.setUp();
        this.include("j2ee.dicon");
    }

    public void testExecuteTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand select = dmd.getSqlCommand("getEmployee");
        Employee before = (Employee)select.execute(new Object[]{new Integer(7369)});
        Employee e = new Employee();
        e.setEmpno(7369L);
        e.setDeptno(20);
        e.setEname("HOGE");
        e.setHiredate(null);
        e.setMgr(null);
        e.setTimestamp(before.getTimestamp());
        SqlCommand unlessNull = dmd.getSqlCommand("updateUnlessNull");
        UpdateAutoDynamicCommandTest.assertTrue((boolean)(unlessNull instanceof UpdateAutoDynamicCommand));
        unlessNull.execute(new Object[]{e});
        Employee after = (Employee)select.execute(new Object[]{new Integer(7369)});
        UpdateAutoDynamicCommandTest.assertEquals((String)e.getEname(), (String)after.getEname());
        UpdateAutoDynamicCommandTest.assertEquals((Object)before.getHiredate(), (Object)after.getHiredate());
        UpdateAutoDynamicCommandTest.assertEquals((Object)before.getMgr(), (Object)after.getMgr());
        UpdateAutoDynamicCommandTest.assertNotSame((Object)before.getTimestamp(), (Object)after.getTimestamp());
    }

    public void testExecuteOnePropertyTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand select = dmd.getSqlCommand("getEmployee");
        Employee before = (Employee)select.execute(new Object[]{new Integer(7369)});
        Employee e = new Employee();
        e.setEmpno(7369L);
        e.setDeptno(20);
        e.setTimestamp(before.getTimestamp());
        SqlCommand unlessNull = dmd.getSqlCommand("updateUnlessNull");
        UpdateAutoDynamicCommandTest.assertTrue((boolean)(unlessNull instanceof UpdateAutoDynamicCommand));
        unlessNull.execute(new Object[]{e});
        Employee after = (Employee)select.execute(new Object[]{new Integer(7369)});
        UpdateAutoDynamicCommandTest.assertEquals((Object)before.getHiredate(), (Object)after.getHiredate());
        UpdateAutoDynamicCommandTest.assertEquals((Object)before.getMgr(), (Object)after.getMgr());
    }

    public void testExecuteAllNullTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(CharTableDao.class);
        SqlCommand insert = dmd.getSqlCommand("insert");
        CharTable data = new CharTable();
        data.setId(1);
        data.setAaa(new Character('c'));
        insert.execute(new Object[]{data});
        SqlCommand unlessNull = dmd.getSqlCommand("updateUnlessNull");
        data.setAaa(null);
        try {
            unlessNull.execute(new Object[]{data});
            UpdateAutoDynamicCommandTest.fail();
        }
        catch (NoUpdatePropertyTypeRuntimeException e) {
            UpdateAutoDynamicCommandTest.assertTrue((boolean)true);
        }
    }

    public void testUpdateUnlessNullVersionNoTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DepartmentAutoDao.class);
        SqlCommand select = dmd.getSqlCommand("getDepartment");
        Department before = (Department)select.execute(new Object[]{new Integer(20)});
        SqlCommand update = dmd.getSqlCommand("updateUnlessNull");
        Department data = new Department();
        data.setDeptno(20);
        data.setDname("HOGE");
        data.setDummy(null);
        data.setVersionNo(before.getVersionNo());
        update.execute(new Object[]{data});
        Department after = (Department)select.execute(new Object[]{new Integer(20)});
        UpdateAutoDynamicCommandTest.assertEquals((String)data.getDname(), (String)after.getDname());
        UpdateAutoDynamicCommandTest.assertEquals((int)(before.getVersionNo() + 1), (int)after.getVersionNo());
        UpdateAutoDynamicCommandTest.assertEquals((String)before.getDummy(), (String)after.getDummy());
    }

    public static interface CharTableDao {
        public static final Class BEAN = class$org$seasar$dao$impl$UpdateAutoDynamicCommandTest$CharTable == null ? (class$org$seasar$dao$impl$UpdateAutoDynamicCommandTest$CharTable = UpdateAutoDynamicCommandTest.class$("org.seasar.dao.impl.UpdateAutoDynamicCommandTest$CharTable")) : class$org$seasar$dao$impl$UpdateAutoDynamicCommandTest$CharTable;

        public void insert(CharTable var1);

        public int updateUnlessNull(CharTable var1);
    }

    public class CharTable {
        public static final String TABLE = "CHAR_TABLE";
        int id = 0;
        Character aaa = null;

        public Character getAaa() {
            return this.aaa;
        }

        public void setAaa(Character aaa) {
            this.aaa = aaa;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }
    }
}

