/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.io.Serializable;
import java.util.List;
import junit.textui.TestRunner;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.RowCreator;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.pager.NullPagingSqlRewriter;
import org.seasar.dao.pager.PagingSqlRewriter;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;

public class SelectDynamicCommandTest
extends S2DaoTestCase {
    static /* synthetic */ Class class$org$seasar$dao$impl$SelectDynamicCommandTest$Emp3;

    public SelectDynamicCommandTest(String arg0) {
        super(arg0);
    }

    public void testExecute() throws Exception {
        SelectDynamicCommand cmd = new SelectDynamicCommand(this.getDataSource(), BasicStatementFactory.INSTANCE, (ResultSetHandler)new BeanMetaDataResultSetHandler(this.createBeanMetaData(Employee.class), this.createRowCreator(), this.createRelationRowCreator()), BasicResultSetFactory.INSTANCE, (PagingSqlRewriter)new NullPagingSqlRewriter());
        cmd.setSql("SELECT * FROM emp WHERE empno = /*empno*/1234");
        Employee emp = (Employee)cmd.execute(new Object[]{new Integer(7788)});
        System.out.println(emp);
        SelectDynamicCommandTest.assertNotNull((String)"1", (Object)emp);
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }

    public void testSelectDynamic() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DynamicDao.class);
        SqlCommand cmd = dmd.getSqlCommand("getEmployeesBySearchCondition");
        SelectDynamicCommandTest.assertTrue((boolean)(cmd instanceof SelectDynamicCommand));
        Employee cond = new Employee();
        cond.setJob("CLERK");
        cond.setEmpno(7369L);
        cond.setDeptno(20);
        List result = (List)cmd.execute(new Object[]{cond});
        SelectDynamicCommandTest.assertEquals((int)1, (int)result.size());
        SelectDynamicCommandTest.assertTrue((boolean)(result.get(0) instanceof Employee));
        cmd = dmd.getSqlCommand("getEmployeeBySearchCondition");
        SelectDynamicCommandTest.assertTrue((boolean)(cmd instanceof SelectDynamicCommand));
        Object obj = cmd.execute(new Object[]{cond});
        SelectDynamicCommandTest.assertTrue((boolean)(obj instanceof Employee));
    }

    public void testSelectByDtoTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(Emp3Dao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        Object[] param = new Object[1];
        for (int i = 0; i < 3; ++i) {
            Emp3 e = new Emp3();
            e.employeeId = new Integer(i);
            e.departmentId = new Integer((i + 1) * 100);
            e.employeeName = "NAME" + String.valueOf(i);
            param[0] = e;
            cmd.execute(param);
        }
        cmd = dmd.getSqlCommand("selectByDto");
        SelectDynamicCommandTest.assertTrue((boolean)(cmd instanceof SelectDynamicCommand));
        Emp3Dto dto = new Emp3Dto();
        dto.employeeName = "NAME1";
        List l = (List)cmd.execute(new Object[]{dto});
        SelectDynamicCommandTest.assertEquals((int)1, (int)l.size());
        cmd = dmd.getSqlCommand("selectByDto2");
        SelectDynamicCommandTest.assertTrue((boolean)(cmd instanceof SelectDynamicCommand));
        Emp3ExDto ex = new Emp3ExDto();
        ex.department_Id = new Integer(200);
        l = (List)cmd.execute(new Object[]{ex});
        SelectDynamicCommandTest.assertEquals((int)1, (int)l.size());
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }

    public static void main(String[] args) {
        TestRunner.run((Class)SelectDynamicCommandTest.class);
    }

    public static interface Emp3Dao {
        public static final Class BEAN = class$org$seasar$dao$impl$SelectDynamicCommandTest$Emp3 == null ? (class$org$seasar$dao$impl$SelectDynamicCommandTest$Emp3 = SelectDynamicCommandTest.class$("org.seasar.dao.impl.SelectDynamicCommandTest$Emp3")) : class$org$seasar$dao$impl$SelectDynamicCommandTest$Emp3;

        public List selectByDto(Emp3Dto var1);

        public List selectByDto2(Emp3ExDto var1);

        public List select(Emp3 var1);

        public void insert(Emp3 var1);
    }

    public static class Emp3 {
        public static String TABLE = "EMP3";
        private Integer employeeId;
        private String employeeName;
        private Integer departmentId;

        public Integer getDepartmentId() {
            return this.departmentId;
        }

        public void setDepartmentId(Integer departmentId) {
            this.departmentId = departmentId;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public void setEmployeeName(String employeeName) {
            this.employeeName = employeeName;
        }

        public Integer getEmployeeId() {
            return this.employeeId;
        }

        public void setEmployeeId(Integer employeeId) {
            this.employeeId = employeeId;
        }
    }

    public static class Emp3ExDto {
        private Integer department_Id;

        public Integer getDepartment_Id() {
            return this.department_Id;
        }

        public void setDepartment_Id(Integer department_Id) {
            this.department_Id = department_Id;
        }
    }

    public static class Emp3Dto {
        private String employeeName;

        public String getEmployeeName() {
            return this.employeeName;
        }

        public void setEmployeeName(String employeeName) {
            this.employeeName = employeeName;
        }
    }

    public static interface DynamicDao {
        public static final Class BEAN = class$org$seasar$dao$impl$Employee == null ? (class$org$seasar$dao$impl$Employee = SelectDynamicCommandTest.class$("org.seasar.dao.impl.Employee")) : class$org$seasar$dao$impl$Employee;

        public List getEmployeesBySearchCondition(Serializable var1);

        public Object getEmployeeBySearchCondition(Serializable var1);

        public int update(Object var1);

        public List getEmployeeByDto(String var1);
    }
}

