/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.Dbms;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.Employee20;
import org.seasar.dao.impl.FieldBeanAnnotationReader;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.unit.S2TestCase;

public class PropertyTypeFactoryImplTest
extends S2TestCase {
    private Class beanClass = Employee20.class;
    private PropertyTypeFactoryBuilder builder;
    private boolean empnoInvoked;
    private boolean managerInvoked;
    private boolean deptnoInvoked;
    private boolean dummyInvoked;

    protected void setUp() throws Exception {
        super.setUp();
        this.include(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".dicon");
    }

    public void testDto() throws Exception {
        PropertyTypeFactory factory = this.createDtoPropertyTypeFactory();
        PropertyType[] propertyTypes = factory.createDtoPropertyTypes();
        PropertyTypeFactoryImplTest.assertNotNull((Object)propertyTypes);
        PropertyTypeFactoryImplTest.assertEquals((int)5, (int)propertyTypes.length);
    }

    public void testBean() throws Exception {
        PropertyTypeFactory factory = this.createBeanPropertyTypeFactory();
        PropertyType[] propertyTypes = factory.createBeanPropertyTypes("EMP");
        PropertyTypeFactoryImplTest.assertNotNull((Object)propertyTypes);
        PropertyTypeFactoryImplTest.assertEquals((int)4, (int)propertyTypes.length);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            if (pt.getPropertyName().equals("empno")) {
                this.empno(pt);
                continue;
            }
            if (pt.getPropertyName().equals("manager")) {
                this.manager(pt);
                continue;
            }
            if (pt.getPropertyName().equals("deptno")) {
                this.deptno(pt);
                continue;
            }
            if (pt.getPropertyName().equals("dummy")) {
                this.dummy(pt);
                continue;
            }
            PropertyTypeFactoryImplTest.fail();
        }
        PropertyTypeFactoryImplTest.assertTrue((boolean)this.empnoInvoked);
        PropertyTypeFactoryImplTest.assertTrue((boolean)this.managerInvoked);
        PropertyTypeFactoryImplTest.assertTrue((boolean)this.deptnoInvoked);
        PropertyTypeFactoryImplTest.assertTrue((boolean)this.dummyInvoked);
    }

    private void empno(PropertyType pt) throws Exception {
        PropertyTypeFactoryImplTest.assertEquals((String)"empno", (String)pt.getColumnName());
        PropertyTypeFactoryImplTest.assertTrue((boolean)pt.isPrimaryKey());
        PropertyTypeFactoryImplTest.assertTrue((boolean)pt.isPersistent());
        PropertyTypeFactoryImplTest.assertEquals((Object)ValueTypes.LONG, (Object)pt.getValueType());
        this.empnoInvoked = true;
    }

    private void manager(PropertyType pt) throws Exception {
        PropertyTypeFactoryImplTest.assertEquals((String)"mgr", (String)pt.getColumnName());
        PropertyTypeFactoryImplTest.assertFalse((boolean)pt.isPrimaryKey());
        PropertyTypeFactoryImplTest.assertTrue((boolean)pt.isPersistent());
        PropertyTypeFactoryImplTest.assertEquals((Object)ValueTypes.SHORT, (Object)pt.getValueType());
        this.managerInvoked = true;
    }

    private void deptno(PropertyType pt) throws Exception {
        PropertyTypeFactoryImplTest.assertEquals((String)"deptno", (String)pt.getColumnName());
        PropertyTypeFactoryImplTest.assertFalse((boolean)pt.isPrimaryKey());
        PropertyTypeFactoryImplTest.assertTrue((boolean)pt.isPersistent());
        PropertyTypeFactoryImplTest.assertEquals((Object)ValueTypes.INTEGER, (Object)pt.getValueType());
        this.deptnoInvoked = true;
    }

    private void dummy(PropertyType pt) throws Exception {
        PropertyTypeFactoryImplTest.assertEquals((String)"dummy", (String)pt.getColumnName());
        PropertyTypeFactoryImplTest.assertFalse((boolean)pt.isPrimaryKey());
        PropertyTypeFactoryImplTest.assertFalse((boolean)pt.isPersistent());
        PropertyTypeFactoryImplTest.assertEquals((Object)ValueTypes.STRING, (Object)pt.getValueType());
        this.dummyInvoked = true;
    }

    private PropertyTypeFactory createDtoPropertyTypeFactory() {
        FieldBeanAnnotationReader beanAnnotationReader = new FieldBeanAnnotationReader(this.beanClass);
        return this.builder.build(this.beanClass, (BeanAnnotationReader)beanAnnotationReader);
    }

    private PropertyTypeFactory createBeanPropertyTypeFactory() {
        FieldBeanAnnotationReader beanAnnotationReader = new FieldBeanAnnotationReader(this.beanClass);
        DatabaseMetaData databaseMetaData = this.getDatabaseMetaData();
        Dbms dbms = DbmsManager.getDbms((DatabaseMetaData)databaseMetaData);
        return this.builder.build(this.beanClass, (BeanAnnotationReader)beanAnnotationReader, dbms, databaseMetaData);
    }
}

