/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import org.seasar.dao.NotSingleResultRuntimeException;
import org.seasar.dao.impl.MapResultSetHandler;
import org.seasar.dao.unit.S2DaoTestCase;

public class MapResultSetHandlerTest
extends S2DaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle() throws Exception {
        MapResultSetHandler handler = new MapResultSetHandler(){

            protected void handleNotSingleResult() {
                throw new AssertionError((Object)"should not be called");
            }
        };
        String sql = "select employee_id, employee_name from emp4 where employee_id = 7369";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Map ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Map)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        MapResultSetHandlerTest.assertNotNull((Object)ret);
        MapResultSetHandlerTest.assertEquals((Object)new Integer(7369), ret.get("employeeId"));
        MapResultSetHandlerTest.assertEquals((Object)"SMITH", ret.get("employeeName"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandleNotSingleRecord() throws Exception {
        final boolean[] calls = new boolean[]{false};
        MapResultSetHandler handler = new MapResultSetHandler(){

            protected final void handleNotSingleResult() {
                super.handleNotSingleResult();
                calls[0] = true;
            }
        };
        String sql = "select employee_id, employee_name from emp4";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Map ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (Map)handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        MapResultSetHandlerTest.assertTrue((boolean)calls[0]);
        MapResultSetHandlerTest.assertNotNull((Object)ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle_restrict() throws Exception {
        MapResultSetHandler.RestrictMapResultSetHandler handler = new MapResultSetHandler.RestrictMapResultSetHandler();
        String sql = "select employee_id, employee_name from emp4";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        Map ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                try {
                    ret = (Map)handler.handle(rs);
                    MapResultSetHandlerTest.fail();
                }
                catch (NotSingleResultRuntimeException e) {
                    MapResultSetHandlerTest.assertTrue((boolean)true);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        MapResultSetHandlerTest.assertNull((Object)ret);
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

