/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import org.seasar.dao.SqlCommand;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeAutoDao;
import org.seasar.dao.impl.IdentityTable;
import org.seasar.dao.impl.IdentityTableAutoDao;
import org.seasar.dao.impl.InsertAutoDynamicCommand;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.StringUtil;

public class InsertAutoDynamicCommandTest
extends S2DaoTestCase {
    static /* synthetic */ Class class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable1;
    static /* synthetic */ Class class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable2;
    static /* synthetic */ Class class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$CompositePk;
    static /* synthetic */ Class class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$Emp;
    static /* synthetic */ Class class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$FooDto;

    public void testExecuteTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        InsertAutoDynamicCommandTest.assertTrue((boolean)(cmd instanceof InsertAutoDynamicCommand));
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("hoge");
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testInsertPkOnlyTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmpDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        Emp emp = new Emp();
        emp.setEmpno(new Integer(980));
        cmd.execute(new Object[]{emp});
    }

    public void testInsertAllNullTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(IdentityTableAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        IdentityTable table = new IdentityTable();
        try {
            cmd.execute(new Object[]{table});
            InsertAutoDynamicCommandTest.fail();
        }
        catch (SRuntimeException e) {
            String message = e.getMessage();
            InsertAutoDynamicCommandTest.assertEquals((boolean)true, (boolean)StringUtil.contains((String)message, (String)"EDAO0014"));
        }
    }

    public void testInsertNoTableTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(FooDtoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        FooDto dto = new FooDto();
        try {
            cmd.execute(new Object[]{dto});
            InsertAutoDynamicCommandTest.fail();
        }
        catch (SRuntimeException e) {
            String message = e.getMessage();
            System.out.println(message);
            InsertAutoDynamicCommandTest.assertEquals((boolean)true, (boolean)StringUtil.contains((String)message, (String)"EDAO0024"));
        }
    }

    public void testExecute2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(IdentityTableAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        IdentityTable table = new IdentityTable();
        table.setIdName("hoge");
        Integer count1 = (Integer)cmd.execute(new Object[]{table});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count1);
        int id1 = table.getMyid();
        System.out.println(id1);
        Integer count2 = (Integer)cmd.execute(new Object[]{table});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count2);
        int id2 = table.getMyid();
        System.out.println(id2);
        InsertAutoDynamicCommandTest.assertEquals((String)"2", (int)1, (int)(id2 - id1));
    }

    public void testExecute3_1Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(SeqTable1Dao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        SeqTable1 table1 = new SeqTable1();
        table1.setName("hoge");
        Integer count = (Integer)cmd.execute(new Object[]{table1});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
        System.out.println(table1.getId());
        InsertAutoDynamicCommandTest.assertTrue((String)"2", (table1.getId() > 0 ? 1 : 0) != 0);
    }

    public void testExecute3_2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(SeqTable2Dao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        SeqTable2 table1 = new SeqTable2();
        table1.setName("hoge");
        Integer count = (Integer)cmd.execute(new Object[]{table1});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
        System.out.println(table1.getId());
        InsertAutoDynamicCommandTest.assertTrue((String)"2", (table1.getId() > 0 ? 1 : 0) != 0);
        SeqTable2 table2 = new SeqTable2();
        table2.setName("foo");
        cmd.execute(new Object[]{table2});
        System.out.println(table2.getId());
        InsertAutoDynamicCommandTest.assertEquals((boolean)true, (table2.getId() > table1.getId() ? 1 : 0) != 0);
    }

    public void testExecute4Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert2");
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("hoge");
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testExecute5Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert3");
        Employee emp = new Employee();
        emp.setEmpno(99L);
        emp.setEname("hoge");
        emp.setDeptno(10);
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        InsertAutoDynamicCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testInsertCompositePk() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(CompositePkDao.class);
        SqlCommand cmd = dmd.getSqlCommand("insert");
        CompositePk compositePk = new CompositePk();
        compositePk.setPk2(10);
        compositePk.setAaa("hoge");
        cmd.execute(new Object[]{compositePk});
        InsertAutoDynamicCommandTest.assertNotNull((Object)compositePk.getPk1());
        InsertAutoDynamicCommandTest.assertEquals((int)10, (int)compositePk.getPk2());
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }

    public static class FooDto {
        public static final String TABLE = "DUMMY_TABLE";
        private Integer empno;
        private String ename;

        public Integer getEmpno() {
            return this.empno;
        }

        public void setEmpno(Integer empno) {
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this.ename = ename;
        }
    }

    public static interface FooDtoDao {
        public static final Class BEAN = class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$FooDto == null ? (class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$FooDto = InsertAutoDynamicCommandTest.class$("org.seasar.dao.impl.InsertAutoDynamicCommandTest$FooDto")) : class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$FooDto;

        public void insert(FooDto var1);
    }

    public static class Emp {
        public static final String TABLE = "EMP";
        private Integer empno;
        private String ename;

        public Integer getEmpno() {
            return this.empno;
        }

        public void setEmpno(Integer empno) {
            this.empno = empno;
        }

        public String getEname() {
            return this.ename;
        }

        public void setEname(String ename) {
            this.ename = ename;
        }
    }

    public static interface EmpDao {
        public static final Class BEAN = class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$Emp == null ? (class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$Emp = InsertAutoDynamicCommandTest.class$("org.seasar.dao.impl.InsertAutoDynamicCommandTest$Emp")) : class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$Emp;

        public void insert(Emp var1);
    }

    public static class CompositePk {
        public static final String TABLE = "COMPOSITE_PK_TABLE";
        public static final String pk1_ID = "sequence, sequenceName=myseq";
        public static final String pk2_ID = "assigned";
        private Integer pk1;
        private int pk2;
        private String aaa;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public Integer getPk1() {
            return this.pk1;
        }

        public void setPk1(Integer pk1) {
            this.pk1 = pk1;
        }

        public int getPk2() {
            return this.pk2;
        }

        public void setPk2(int pk2) {
            this.pk2 = pk2;
        }
    }

    public static interface CompositePkDao {
        public static final Class BEAN = class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$CompositePk == null ? (class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$CompositePk = InsertAutoDynamicCommandTest.class$("org.seasar.dao.impl.InsertAutoDynamicCommandTest$CompositePk")) : class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$CompositePk;

        public void insert(CompositePk var1);
    }

    public static class SeqTable2 {
        public static final String TABLE = "SEQTABLE";
        public static final String id_ID = "sequence, sequenceName=myseq";
        private Integer id;
        private String name;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static interface SeqTable2Dao {
        public static final Class BEAN = class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable2 == null ? (class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable2 = InsertAutoDynamicCommandTest.class$("org.seasar.dao.impl.InsertAutoDynamicCommandTest$SeqTable2")) : class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable2;

        public void insert(SeqTable2 var1);
    }

    public static class SeqTable1 {
        public static final String TABLE = "SEQTABLE";
        public static final String id_ID = "sequence, sequenceName=myseq";
        private int id;
        private String name;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static interface SeqTable1Dao {
        public static final Class BEAN = class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable1 == null ? (class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable1 = InsertAutoDynamicCommandTest.class$("org.seasar.dao.impl.InsertAutoDynamicCommandTest$SeqTable1")) : class$org$seasar$dao$impl$InsertAutoDynamicCommandTest$SeqTable1;

        public void insert(SeqTable1 var1);
    }
}

