/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.DatabaseMetaData;
import org.seasar.dao.BeanAnnotationReader;
import org.seasar.dao.Dbms;
import org.seasar.dao.PropertyTypeFactory;
import org.seasar.dao.PropertyTypeFactoryBuilder;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.Employee21;
import org.seasar.dao.impl.FieldBeanAnnotationReader;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.types.ValueTypes;
import org.seasar.extension.unit.S2TestCase;

public class FastPropertyTypeFactoryTest
extends S2TestCase {
    private PropertyTypeFactoryBuilder builder;
    private Class beanClass = Employee21.class;
    private boolean empnoInvoked;
    private boolean managerInvoked;
    private boolean deptnoInvoked;
    private boolean dummyInvoked;
    private boolean modifiedPropertyNamesInvoked;

    protected void setUp() throws Exception {
        super.setUp();
        this.include(((Object)((Object)this)).getClass().getName().replace('.', '/') + ".dicon");
    }

    public void testDto() throws Exception {
        PropertyTypeFactory factory = this.createDtoPropertyTypeFactory();
        PropertyType[] propertyTypes = factory.createDtoPropertyTypes();
        FastPropertyTypeFactoryTest.assertNotNull((Object)propertyTypes);
        FastPropertyTypeFactoryTest.assertEquals((int)6, (int)propertyTypes.length);
    }

    public void testBean() throws Exception {
        PropertyTypeFactory factory = this.createBeanPropertyTypeFactory();
        PropertyType[] propertyTypes = factory.createBeanPropertyTypes("EMP");
        FastPropertyTypeFactoryTest.assertNotNull((Object)propertyTypes);
        FastPropertyTypeFactoryTest.assertEquals((int)5, (int)propertyTypes.length);
        for (int i = 0; i < propertyTypes.length; ++i) {
            PropertyType pt = propertyTypes[i];
            if (pt.getPropertyName().equals("empno")) {
                this.empno(pt);
                continue;
            }
            if (pt.getPropertyName().equals("manager")) {
                this.manager(pt);
                continue;
            }
            if (pt.getPropertyName().equals("deptno")) {
                this.deptno(pt);
                continue;
            }
            if (pt.getPropertyName().equals("dummy")) {
                this.dummy(pt);
                continue;
            }
            if (pt.getPropertyName().equals("modifiedPropertyNames")) {
                this.modifiedPropertyNames(pt);
                continue;
            }
            FastPropertyTypeFactoryTest.fail();
        }
        FastPropertyTypeFactoryTest.assertTrue((boolean)this.empnoInvoked);
        FastPropertyTypeFactoryTest.assertTrue((boolean)this.managerInvoked);
        FastPropertyTypeFactoryTest.assertTrue((boolean)this.deptnoInvoked);
        FastPropertyTypeFactoryTest.assertTrue((boolean)this.dummyInvoked);
        FastPropertyTypeFactoryTest.assertTrue((boolean)this.modifiedPropertyNamesInvoked);
    }

    private void empno(PropertyType pt) throws Exception {
        FastPropertyTypeFactoryTest.assertEquals((String)"empno", (String)pt.getColumnName());
        FastPropertyTypeFactoryTest.assertTrue((boolean)pt.isPrimaryKey());
        FastPropertyTypeFactoryTest.assertTrue((boolean)pt.isPersistent());
        FastPropertyTypeFactoryTest.assertEquals((Object)ValueTypes.LONG, (Object)pt.getValueType());
        this.empnoInvoked = true;
    }

    private void manager(PropertyType pt) throws Exception {
        FastPropertyTypeFactoryTest.assertEquals((String)"mgr", (String)pt.getColumnName());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPrimaryKey());
        FastPropertyTypeFactoryTest.assertTrue((boolean)pt.isPersistent());
        FastPropertyTypeFactoryTest.assertEquals((Object)ValueTypes.SHORT, (Object)pt.getValueType());
        this.managerInvoked = true;
    }

    private void deptno(PropertyType pt) throws Exception {
        FastPropertyTypeFactoryTest.assertEquals((String)"deptno", (String)pt.getColumnName());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPrimaryKey());
        FastPropertyTypeFactoryTest.assertTrue((boolean)pt.isPersistent());
        FastPropertyTypeFactoryTest.assertEquals((Object)ValueTypes.INTEGER, (Object)pt.getValueType());
        this.deptnoInvoked = true;
    }

    private void dummy(PropertyType pt) throws Exception {
        FastPropertyTypeFactoryTest.assertEquals((String)"dummy", (String)pt.getColumnName());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPrimaryKey());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPersistent());
        FastPropertyTypeFactoryTest.assertEquals((Object)ValueTypes.STRING, (Object)pt.getValueType());
        this.dummyInvoked = true;
    }

    private void modifiedPropertyNames(PropertyType pt) throws Exception {
        FastPropertyTypeFactoryTest.assertEquals((String)"modifiedPropertyNames", (String)pt.getColumnName());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPrimaryKey());
        FastPropertyTypeFactoryTest.assertFalse((boolean)pt.isPersistent());
        FastPropertyTypeFactoryTest.assertEquals((Object)ValueTypes.OBJECT, (Object)pt.getValueType());
        this.modifiedPropertyNamesInvoked = true;
    }

    private PropertyTypeFactory createDtoPropertyTypeFactory() {
        FieldBeanAnnotationReader beanAnnotationReader = new FieldBeanAnnotationReader(this.beanClass);
        return this.builder.build(this.beanClass, (BeanAnnotationReader)beanAnnotationReader);
    }

    private PropertyTypeFactory createBeanPropertyTypeFactory() {
        FieldBeanAnnotationReader beanAnnotationReader = new FieldBeanAnnotationReader(this.beanClass);
        DatabaseMetaData databaseMetaData = this.getDatabaseMetaData();
        Dbms dbms = DbmsManager.getDbms((DatabaseMetaData)this.getDatabaseMetaData());
        return this.builder.build(this.beanClass, (BeanAnnotationReader)beanAnnotationReader, dbms, databaseMetaData);
    }
}

