/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.DtoArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.EmployeeDto;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.unit.S2DaoTestCase;

public class DtoArrayMetaDataResultSetHandlerTest
extends S2DaoTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testHandle() throws Exception {
        DtoArrayMetaDataResultSetHandler handler = new DtoArrayMetaDataResultSetHandler((DtoMetaData)this.createDtoMetaData(EmployeeDto.class), this.createRowCreator());
        String sql = "select empno, ename, dname from emp, dept where empno = 7788 and emp.deptno = dept.deptno";
        Connection con = this.getConnection();
        PreparedStatement ps = con.prepareStatement(sql);
        EmployeeDto[] ret = null;
        try {
            ResultSet rs = ps.executeQuery();
            try {
                ret = (EmployeeDto[])handler.handle(rs);
            }
            finally {
                rs.close();
            }
        }
        finally {
            ps.close();
        }
        DtoArrayMetaDataResultSetHandlerTest.assertNotNull((Object)ret);
        DtoArrayMetaDataResultSetHandlerTest.assertEquals((int)1, (int)ret.length);
        EmployeeDto dto = ret[0];
        DtoArrayMetaDataResultSetHandlerTest.assertEquals((long)7788L, (long)dto.getEmpno());
        DtoArrayMetaDataResultSetHandlerTest.assertEquals((String)"SCOTT", (String)dto.getEname());
        DtoArrayMetaDataResultSetHandlerTest.assertEquals((String)"RESEARCH", (String)dto.getDname());
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }
}

