/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import junit.textui.TestRunner;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.UpdateFailureRuntimeException;
import org.seasar.dao.impl.DaoMetaDataImpl;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.Department;
import org.seasar.dao.impl.DepartmentAutoDao;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.EmployeeAutoDao;
import org.seasar.dao.unit.S2DaoTestCase;

public class DeleteAutoStaticCommandTest
extends S2DaoTestCase {
    public DeleteAutoStaticCommandTest(String arg0) {
        super(arg0);
    }

    public void testExecuteTx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(EmployeeAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("delete");
        SqlCommand cmd2 = dmd.getSqlCommand("getEmployee");
        Employee emp = (Employee)cmd2.execute(new Object[]{new Integer(7788)});
        Integer count = (Integer)cmd.execute(new Object[]{emp});
        DeleteAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testExecute2Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DepartmentAutoDao.class);
        SqlCommand cmd = dmd.getSqlCommand("delete");
        Department dept = new Department();
        dept.setDeptno(10);
        Integer count = (Integer)cmd.execute(new Object[]{dept});
        DeleteAutoStaticCommandTest.assertEquals((String)"1", (Object)new Integer(1), (Object)count);
    }

    public void testExecute3Tx() throws Exception {
        DaoMetaDataImpl dmd = this.createDaoMetaData(DepartmentAutoDao.class);
        DeleteAutoStaticCommand cmd = (DeleteAutoStaticCommand)dmd.getSqlCommand("delete");
        Department dept = new Department();
        dept.setDeptno(10);
        dept.setVersionNo(-1);
        try {
            cmd.execute(new Object[]{dept});
            DeleteAutoStaticCommandTest.fail((String)"1");
        }
        catch (UpdateFailureRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void setUp() {
        this.include("j2ee.dicon");
    }

    public static void main(String[] args) {
        TestRunner.run((Class)DeleteAutoStaticCommandTest.class);
    }
}

