/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Random;
import org.seasar.extension.unit.S2TestCase;

public class BlobTest
extends S2TestCase {
    private LargeBinaryDao largeBinaryByteArrayDao;
    private LargeBinaryStreamDao largeBinaryStreamDao;
    static /* synthetic */ Class class$org$seasar$dao$impl$BlobTest$LargeBinary;
    static /* synthetic */ Class class$org$seasar$dao$impl$BlobTest$LargeBinaryStream;

    protected void setUp() throws Exception {
        super.setUp();
        this.include("BlobTest.dicon");
    }

    public void testBinary1Tx() throws Exception {
        BlobTest.assertNotNull((Object)this.largeBinaryByteArrayDao);
        LargeBinary largeBinary = this.largeBinaryByteArrayDao.getLargeBinary(123);
        this.assertEquals(null, largeBinary);
    }

    public void testBinary2Tx() throws Exception {
        LargeBinary largeBinary = new LargeBinary();
        largeBinary.setId(111);
        largeBinary.setLargeBinary("aabbcc".getBytes());
        this.largeBinaryByteArrayDao.insert(largeBinary);
        largeBinary = this.largeBinaryByteArrayDao.getLargeBinary(111);
        this.assertEquals("aabbcc".getBytes(), largeBinary.getLargeBinary());
        BlobTest.assertEquals((int)0, (int)largeBinary.getVersionNo());
        largeBinary.setLargeBinary("ABCDEFG".getBytes());
        this.largeBinaryByteArrayDao.update(largeBinary);
        largeBinary = this.largeBinaryByteArrayDao.getLargeBinary(111);
        this.assertEquals("ABCDEFG".getBytes(), largeBinary.getLargeBinary());
        BlobTest.assertEquals((int)1, (int)largeBinary.getVersionNo());
        this.largeBinaryByteArrayDao.delete(largeBinary);
        largeBinary = this.largeBinaryByteArrayDao.getLargeBinary(111);
        this.assertEquals(null, largeBinary);
    }

    public void testBinary3Tx() throws Exception {
        Random random = new Random();
        byte[] bytes = new byte[5120];
        random.nextBytes(bytes);
        LargeBinary largeBinary = new LargeBinary();
        largeBinary.setId(4321);
        largeBinary.setLargeBinary(bytes);
        this.largeBinaryByteArrayDao.insert(largeBinary);
        largeBinary = this.largeBinaryByteArrayDao.getLargeBinary(4321);
        this.assertEquals(bytes, largeBinary.getLargeBinary());
        BlobTest.assertEquals((int)0, (int)largeBinary.getVersionNo());
    }

    public void testBinaryStream1Tx() throws Exception {
        BlobTest.assertNotNull((Object)this.largeBinaryStreamDao);
        LargeBinaryStream largeBinary = this.largeBinaryStreamDao.getLargeBinary(123);
        this.assertEquals(null, largeBinary);
    }

    public void no_testBinaryStream2Tx() throws Exception {
        LargeBinaryStream largeBinary = new LargeBinaryStream();
        largeBinary.setId(321);
        largeBinary.setLargeBinary(this.toInputStream("zxcvb"));
        this.largeBinaryStreamDao.insert(largeBinary);
        largeBinary = this.largeBinaryStreamDao.getLargeBinary(321);
        this.assertEquals(this.toInputStream("zxcvb"), largeBinary.getLargeBinary());
        BlobTest.assertEquals((int)0, (int)largeBinary.getVersionNo());
        largeBinary.setLargeBinary(this.toInputStream("AAA"));
        this.largeBinaryStreamDao.update(largeBinary);
        largeBinary = this.largeBinaryStreamDao.getLargeBinary(321);
        this.assertEquals(this.toInputStream("AAA"), largeBinary.getLargeBinary());
        BlobTest.assertEquals((int)1, (int)largeBinary.getVersionNo());
    }

    private InputStream toInputStream(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }

    private void assertEquals(InputStream expected, InputStream actual) throws IOException {
        int act;
        int exp;
        do {
            if ((exp = expected.read()) == (act = actual.read())) continue;
            BlobTest.fail();
            return;
        } while (exp != -1 && act != -1);
    }

    private void assertEquals(byte[] expected, byte[] actual) {
        if (expected.length != actual.length) {
            BlobTest.fail();
            return;
        }
        for (int i = 0; i < actual.length; ++i) {
            if (expected[i] == actual[i]) continue;
            BlobTest.fail();
            return;
        }
    }

    public static class LargeBinaryStream
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String TABLE = "LARGE_BINARY";
        private int id;
        private InputStream largeBinary;
        private int versionNo;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public InputStream getLargeBinary() {
            return this.largeBinary;
        }

        public void setLargeBinary(InputStream largeBinary) {
            this.largeBinary = largeBinary;
        }

        public int getVersionNo() {
            return this.versionNo;
        }

        public void setVersionNo(int versionNo) {
            this.versionNo = versionNo;
        }
    }

    public static class LargeBinary
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final String TABLE = "LARGE_BINARY";
        private int id;
        private byte[] largeBinary;
        private int versionNo;

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public byte[] getLargeBinary() {
            return this.largeBinary;
        }

        public void setLargeBinary(byte[] largeBinary) {
            this.largeBinary = largeBinary;
        }

        public int getVersionNo() {
            return this.versionNo;
        }

        public void setVersionNo(int versionNo) {
            this.versionNo = versionNo;
        }
    }

    public static interface LargeBinaryStreamDao {
        public static final Class BEAN = class$org$seasar$dao$impl$BlobTest$LargeBinaryStream == null ? (class$org$seasar$dao$impl$BlobTest$LargeBinaryStream = BlobTest.class$("org.seasar.dao.impl.BlobTest$LargeBinaryStream")) : class$org$seasar$dao$impl$BlobTest$LargeBinaryStream;
        public static final String getLargeBinary_ARGS = "id";

        public LargeBinaryStream getLargeBinary(int var1);

        public void insert(LargeBinaryStream var1);

        public void update(LargeBinaryStream var1);
    }

    public static interface LargeBinaryDao {
        public static final Class BEAN = class$org$seasar$dao$impl$BlobTest$LargeBinary == null ? (class$org$seasar$dao$impl$BlobTest$LargeBinary = BlobTest.class$("org.seasar.dao.impl.BlobTest$LargeBinary")) : class$org$seasar$dao$impl$BlobTest$LargeBinary;
        public static final String getLargeBinary_ARGS = "id";

        public LargeBinary getLargeBinary(int var1);

        public void insert(LargeBinary var1);

        public void update(LargeBinary var1);

        public void delete(LargeBinary var1);
    }
}

