/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import junit.framework.Assert;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.BeanMetaDataFactory;
import org.seasar.dao.NullBean;
import org.seasar.dao.impl.BeanMetaDataFactoryImpl;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.Employee;
import org.seasar.dao.impl.NullBeanMetaData;
import org.seasar.dao.unit.S2DaoTestCase;

public class BeanMetaDataFactoryImplTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include("dao.dicon");
    }

    public void test_Accessor() {
        String invokeMark = "test_Accessor()";
        BeanMetaDataFactoryImpl beanMetaDataFactoryImpl = new BeanMetaDataFactoryImpl(){

            public String toString() {
                Assert.assertNotNull((Object)this.annotationReaderFactory);
                return "test_Accessor()";
            }
        };
        beanMetaDataFactoryImpl.setAnnotationReaderFactory(this.getAnnotationReaderFactory());
        BeanMetaDataFactoryImplTest.assertEquals((String)"test_Accessor()", (String)beanMetaDataFactoryImpl.toString());
    }

    public void test_createBeanMetaData_Tx() {
        BeanMetaDataFactory bmdFactory = this.getBeanMetaDataFactory();
        Class beanClass = Employee.class;
        BeanMetaData bmd = bmdFactory.createBeanMetaData(beanClass);
        BeanMetaDataFactoryImplTest.assertNotNull((Object)bmd);
        BeanMetaDataFactoryImplTest.assertNotNull((Object)bmd.getBeanClass());
        BeanMetaDataFactoryImplTest.assertEquals((String)"EMP", (String)bmd.getTableName());
        int relationPropertyTypeSize = bmd.getRelationPropertyTypeSize();
        BeanMetaDataFactoryImplTest.assertNotSame((Object)new Integer(0), (Object)new Integer(relationPropertyTypeSize));
        for (int i = 0; i < relationPropertyTypeSize; ++i) {
            BeanMetaDataFactoryImplTest.assertNotNull((Object)bmd.getRelationPropertyType(i));
        }
    }

    public void test_createBeanMetaData_NestLevelOne_Tx() {
        BeanMetaDataFactory bmdFactory = this.getBeanMetaDataFactory();
        Class beanClass = Employee.class;
        BeanMetaData bmd = bmdFactory.createBeanMetaData(beanClass, 1);
        BeanMetaDataFactoryImplTest.assertNotNull((Object)bmd);
        BeanMetaDataFactoryImplTest.assertNotNull((Object)bmd.getBeanClass());
        BeanMetaDataFactoryImplTest.assertEquals((String)"EMP", (String)bmd.getTableName());
        int relationPropertyTypeSize = bmd.getRelationPropertyTypeSize();
        BeanMetaDataFactoryImplTest.assertEquals((Object)new Integer(0), (Object)new Integer(relationPropertyTypeSize));
    }

    public void test_newBeanMetaDataImpl() {
        String invokeMark = "test_newBeanMetaDataImpl()";
        BeanMetaDataFactoryImpl beanMetaDataFactoryImpl = new BeanMetaDataFactoryImpl(){

            public String toString() {
                BeanMetaDataImpl beanMetaDataImpl = super.createBeanMetaDataImpl();
                Assert.assertNotNull((Object)beanMetaDataImpl);
                return "test_newBeanMetaDataImpl()";
            }
        };
        BeanMetaDataFactoryImplTest.assertEquals((String)"test_newBeanMetaDataImpl()", (String)beanMetaDataFactoryImpl.toString());
    }

    public void test_isRelationNestLevel() {
        String invokeMark = "test_isRelationNestLevel()";
        BeanMetaDataFactoryImpl beanMetaDataFactoryImpl = new BeanMetaDataFactoryImpl(){

            public String toString() {
                int relationNestLevel = 0;
                boolean isRelationNestLevel = super.isLimitRelationNestLevel(0);
                Assert.assertEquals((0 == super.getLimitRelationNestLevel() ? 1 : 0) != 0, (boolean)isRelationNestLevel);
                relationNestLevel = 1;
                isRelationNestLevel = super.isLimitRelationNestLevel(1);
                Assert.assertEquals((1 == super.getLimitRelationNestLevel() ? 1 : 0) != 0, (boolean)isRelationNestLevel);
                relationNestLevel = 2;
                isRelationNestLevel = super.isLimitRelationNestLevel(2);
                Assert.assertEquals((2 == super.getLimitRelationNestLevel() ? 1 : 0) != 0, (boolean)isRelationNestLevel);
                return "test_isRelationNestLevel()";
            }
        };
        BeanMetaDataFactoryImplTest.assertEquals((String)"test_isRelationNestLevel()", (String)beanMetaDataFactoryImpl.toString());
    }

    public void test_getLimitRelationNestLevel() {
        String invokeMark = "test_getLimitRelationNestLevel()";
        BeanMetaDataFactoryImpl beanMetaDataFactoryImpl = new BeanMetaDataFactoryImpl(){

            public String toString() {
                int level = super.getLimitRelationNestLevel();
                Assert.assertEquals((int)1, (int)level);
                return "test_getLimitRelationNestLevel()";
            }
        };
        BeanMetaDataFactoryImplTest.assertEquals((String)"test_getLimitRelationNestLevel()", (String)beanMetaDataFactoryImpl.toString());
    }

    public void testCreateBeanMetaData_byNullClass() throws Exception {
        BeanMetaDataFactoryImpl factory = new BeanMetaDataFactoryImpl();
        try {
            factory.createBeanMetaData((Class)null);
            BeanMetaDataFactoryImplTest.fail();
        }
        catch (NullPointerException e) {
            BeanMetaDataFactoryImplTest.assertTrue((e.getMessage() != null && 0 < e.getMessage().length() ? 1 : 0) != 0);
        }
    }

    public void testCreateBeanMetaData_byNullBean() throws Exception {
        BeanMetaDataFactoryImpl factory = new BeanMetaDataFactoryImpl();
        BeanMetaData metaData = factory.createBeanMetaData(HogeDao.class, NullBean.class);
        BeanMetaDataFactoryImplTest.assertEquals((Object)NullBeanMetaData.class, metaData.getClass());
    }

    public static class HogeDao {
    }
}

