/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.dbms.HSQL;
import org.seasar.dao.dbms.Oracle;

public abstract class AbstractDaoAnnotationReaderImplTest
extends TestCase {
    protected DaoAnnotationReader annotationReader;
    protected Class clazz;
    protected Class aaaClazz;
    protected Class daoClazz;

    public void testBasic() throws Exception {
        AbstractDaoAnnotationReaderImplTest.assertEquals((Object)this.aaaClazz, (Object)this.annotationReader.getBeanClass());
        String query = this.annotationReader.getQuery(this.daoClazz.getMethod("getAaaById2", Integer.TYPE));
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"A > B", (String)query);
    }

    public void testBeanClassByMethod() throws Exception {
        Method method = this.daoClazz.getMethod("findAll", null);
        AbstractDaoAnnotationReaderImplTest.assertEquals((Object)this.aaaClazz, (Object)this.annotationReader.getBeanClass(method));
        method = this.daoClazz.getMethod("findArray", null);
        AbstractDaoAnnotationReaderImplTest.assertEquals((Object)this.aaaClazz, (Object)this.annotationReader.getBeanClass(method));
        method = this.daoClazz.getMethod("findSimpleTypeArray", null);
        AbstractDaoAnnotationReaderImplTest.assertEquals(Integer.TYPE, (Object)this.annotationReader.getBeanClass(method));
        method = this.daoClazz.getMethod("find", Integer.TYPE);
        AbstractDaoAnnotationReaderImplTest.assertEquals((Object)this.aaaClazz, (Object)this.annotationReader.getBeanClass(method));
    }

    public void testBeanClass() throws Exception {
        AbstractDaoAnnotationReaderImplTest.assertEquals((Object)this.aaaClazz, (Object)this.annotationReader.getBeanClass());
    }

    public void testQuery() throws Exception {
        String query = this.annotationReader.getQuery(this.clazz.getMethod("getAaaById2", Integer.TYPE));
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"A > B", (String)query);
    }

    public void testSql() throws Exception {
        String sql = this.annotationReader.getSQL(this.clazz.getMethod("getAaaById3", Integer.TYPE), null);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"SELECT * FROM AAA", (String)sql);
    }

    public void testSql2() throws Exception {
        String sql = this.annotationReader.getSQL(this.clazz.getMethod("selectB", Integer.TYPE), new Oracle().getSuffix());
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"SELECT * FROM BBB", (String)sql);
        sql = this.annotationReader.getSQL(this.clazz.getMethod("selectB", Integer.TYPE), new HSQL().getSuffix());
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"2", (String)"SELECT * FROM DDD", (String)sql);
        sql = this.annotationReader.getSQL(this.clazz.getMethod("selectC", Integer.TYPE), new Oracle().getSuffix());
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"3", (String)"SELECT * FROM CCC", (String)sql);
        sql = this.annotationReader.getSQL(this.clazz.getMethod("selectC", Integer.TYPE), new HSQL().getSuffix());
        AbstractDaoAnnotationReaderImplTest.assertNull((String)"4", (Object)sql);
    }

    public void testArgNames() throws Exception {
        String[] argNames = this.annotationReader.getArgNames(this.clazz.getMethod("getAaaById1", Integer.TYPE));
        AbstractDaoAnnotationReaderImplTest.assertEquals((int)2, (int)argNames.length);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"aaa1", (String)argNames[0]);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"aaa2", (String)argNames[1]);
    }

    public void testNoPersistentProps() throws Exception {
        String[] noPersistentProps = this.annotationReader.getNoPersistentProps(this.clazz.getMethod("createAaa1", this.aaaClazz));
        AbstractDaoAnnotationReaderImplTest.assertEquals((int)1, (int)noPersistentProps.length);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"abc", (String)noPersistentProps[0]);
    }

    public void testPersistentProps() throws Exception {
        String[] persistentProps = this.annotationReader.getPersistentProps(this.clazz.getMethod("createAaa2", this.aaaClazz));
        AbstractDaoAnnotationReaderImplTest.assertEquals((int)1, (int)persistentProps.length);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"def", (String)persistentProps[0]);
    }

    public void testSqlFile() throws Exception {
        Method method = this.daoClazz.getMethod("findUsingSqlFile", Integer.TYPE);
        boolean isSqlFile = this.annotationReader.isSqlFile(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((boolean)true, (boolean)isSqlFile);
    }

    public void testNoSqlFile() throws Exception {
        Method method = this.daoClazz.getMethod("getAaaById1", Integer.TYPE);
        boolean isSqlFile = this.annotationReader.isSqlFile(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((boolean)false, (boolean)isSqlFile);
    }

    public void testSqlFileWithPath() throws Exception {
        Method method = this.daoClazz.getMethod("findUsingSqlFile2", Integer.TYPE);
        String sqlFile = this.annotationReader.getSqlFilePath(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"org/seasar/dao/impl/sqlfile/testFile.sql", (String)sqlFile);
    }

    public void testSqlFileWithoutPath() throws Exception {
        Method method = this.daoClazz.getMethod("findUsingSqlFile", Integer.TYPE);
        String sqlFile = this.annotationReader.getSqlFilePath(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"1", (String)"", (String)sqlFile);
        method = this.daoClazz.getMethod("getAaaById1", Integer.TYPE);
        sqlFile = this.annotationReader.getSqlFilePath(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"2", (String)"", (String)sqlFile);
    }

    public void testProcedureCall() throws Exception {
        Method method = this.daoClazz.getMethod("execute", new Class[0]);
        String name = this.annotationReader.getProcedureCallName(method);
        AbstractDaoAnnotationReaderImplTest.assertEquals((String)"hoge", (String)name);
    }

    public void testNoCheckSingleRowUpdateOnMethod() throws Exception {
        Method method = this.daoClazz.getMethod("createAaa3", this.aaaClazz);
        boolean resultCheck = this.annotationReader.isCheckSingleRowUpdate(method);
        AbstractDaoAnnotationReaderImplTest.assertFalse((boolean)resultCheck);
    }

    public void testCheckSingleRowUpdateOnMethod() throws Exception {
        Method method = this.daoClazz.getMethod("createAaa2", this.aaaClazz);
        boolean resultCheck = this.annotationReader.isCheckSingleRowUpdate(method);
        AbstractDaoAnnotationReaderImplTest.assertTrue((boolean)resultCheck);
    }

    public void testNoCheckSingleRowUpdateOnDao() throws Exception {
        boolean resultCheck = this.annotationReader.isCheckSingleRowUpdate();
        AbstractDaoAnnotationReaderImplTest.assertFalse((boolean)resultCheck);
    }
}

