/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import org.seasar.dao.BeanMetaData;
import org.seasar.dao.Dbms;
import org.seasar.dao.dbms.Employee;
import org.seasar.dao.dbms.Standard;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.framework.exception.SRuntimeException;
import org.seasar.framework.util.DisposableUtil;

public class StandardTest
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        this.include("j2ee.dicon");
        Standard dbms = new Standard();
        this.setDbms((Dbms)dbms);
    }

    public void testCreateAutoSelectList() throws Exception {
        BeanMetaData bmd = this.createBeanMetaData(Employee.class);
        String sql = this.getDbms().getAutoSelectSql(bmd);
        System.out.println(sql);
    }

    public void testDispose() throws Exception {
        Standard standard = new Standard();
        this.setDbms((Dbms)standard);
        StandardTest.assertEquals((int)0, (int)standard.autoSelectFromClauseCache.size());
        BeanMetaData bmd = this.createBeanMetaData(Employee.class);
        String sql = standard.getAutoSelectSql(bmd);
        StandardTest.assertNotNull((Object)sql);
        StandardTest.assertEquals((int)1, (int)standard.autoSelectFromClauseCache.size());
        DisposableUtil.dispose();
        StandardTest.assertEquals((int)0, (int)standard.autoSelectFromClauseCache.size());
        sql = standard.getAutoSelectSql(bmd);
        StandardTest.assertNotNull((Object)sql);
        StandardTest.assertEquals((int)1, (int)standard.autoSelectFromClauseCache.size());
        DisposableUtil.dispose();
        StandardTest.assertEquals((int)0, (int)standard.autoSelectFromClauseCache.size());
    }

    public void testGetIdentitySelectString() throws Exception {
        try {
            this.getDbms().getIdentitySelectString();
            StandardTest.fail();
        }
        catch (SRuntimeException e) {
            StandardTest.assertEquals((String)"EDAO0022", (String)e.getMessageCode());
            System.out.println((Object)e);
        }
    }

    public void testGetSequenceNextValString() throws Exception {
        try {
            this.getDbms().getSequenceNextValString(null);
            StandardTest.fail();
        }
        catch (SRuntimeException e) {
            StandardTest.assertEquals((String)"EDAO0022", (String)e.getMessageCode());
            System.out.println((Object)e);
        }
    }
}

