/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.dbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.dao.Dbms;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.dbms.H2;
import org.seasar.dao.unit.S2DaoTestCase;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.BasicSelectHandler;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;

public class H2Test
extends S2DaoTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.include("j2ee-h2.dicon");
    }

    public void test1() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("DROP TABLE IF EXISTS H2TEST");
        stmt.executeUpdate("CREATE TABLE H2TEST (ID INT PRIMARY KEY, AAA VARCHAR(255))");
        stmt.executeUpdate("INSERT INTO H2TEST VALUES (1, 'z')");
        stmt.executeUpdate("INSERT INTO H2TEST VALUES (2, 'y')");
        stmt.executeUpdate("INSERT INTO H2TEST VALUES (3, 'x')");
        ResultSet rset = stmt.executeQuery("SELECT COUNT(*) FROM H2TEST");
        H2Test.assertEquals((boolean)true, (boolean)rset.next());
        H2Test.assertEquals((int)1, (int)rset.getMetaData().getColumnCount());
        H2Test.assertEquals((long)3L, (long)rset.getLong(1));
        H2Test.assertEquals((boolean)false, (boolean)rset.next());
        rset.close();
        rset = stmt.executeQuery("SELECT ID, AAA FROM H2TEST ORDER BY 2 ASC");
        H2Test.assertEquals((int)2, (int)rset.getMetaData().getColumnCount());
        H2Test.assertEquals((boolean)true, (boolean)rset.next());
        H2Test.assertEquals((String)"3", (String)rset.getString(1));
        H2Test.assertEquals((String)"x", (String)rset.getString(2));
        H2Test.assertEquals((boolean)true, (boolean)rset.next());
        H2Test.assertEquals((String)"2", (String)rset.getString(1));
        H2Test.assertEquals((String)"y", (String)rset.getString(2));
        H2Test.assertEquals((boolean)true, (boolean)rset.next());
        H2Test.assertEquals((String)"1", (String)rset.getString(1));
        H2Test.assertEquals((String)"z", (String)rset.getString(2));
        H2Test.assertEquals((boolean)false, (boolean)rset.next());
        stmt.close();
        con.close();
    }

    public void testSequence() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("DROP SEQUENCE IF EXISTS H2TEST_SEQ");
        stmt.executeUpdate("CREATE SEQUENCE H2TEST_SEQ START WITH 7650 INCREMENT BY 1");
        stmt.close();
        Dbms dbms = DbmsManager.getDbms((DataSource)this.getDataSource());
        H2Test.assertEquals((boolean)true, (boolean)(dbms instanceof H2));
        String sequenceNextValString = dbms.getSequenceNextValString("H2TEST_SEQ");
        BasicSelectHandler nextvalHandler = new BasicSelectHandler(this.getDataSource(), sequenceNextValString, (ResultSetHandler)new ObjectResultSetHandler());
        Number nextval = (Number)nextvalHandler.execute(null);
        H2Test.assertEquals((int)7650, (int)nextval.intValue());
        nextval = (Number)nextvalHandler.execute(null);
        H2Test.assertEquals((int)7651, (int)nextval.intValue());
        nextval = (Number)nextvalHandler.execute(null);
        H2Test.assertEquals((int)7652, (int)nextval.intValue());
        String identitySelectString = dbms.getIdentitySelectString();
        BasicSelectHandler identityHandler = new BasicSelectHandler(this.getDataSource(), identitySelectString, (ResultSetHandler)new ObjectResultSetHandler());
        Number currval = (Number)identityHandler.execute(null);
        H2Test.assertEquals((int)7652, (int)currval.intValue());
        currval = (Number)identityHandler.execute(null);
        H2Test.assertEquals((int)7652, (int)currval.intValue());
        nextvalHandler.execute(null);
        currval = (Number)identityHandler.execute(null);
        H2Test.assertEquals((int)7653, (int)currval.intValue());
    }
}

