/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.pager;

import org.seasar.dao.pager.AbstractPagingSqlRewriter;

public class OracleRownumPagingSqlRewriter
extends AbstractPagingSqlRewriter {
    protected String makeCountSql(String baseSQL) {
        StringBuffer sqlBuf = new StringBuffer("SELECT count(*) FROM (");
        if (this.isChopOrderBy()) {
            sqlBuf.append(this.chopOrderBy(baseSQL));
        } else {
            sqlBuf.append(baseSQL);
        }
        sqlBuf.append(")");
        return sqlBuf.toString();
    }

    protected String makeLimitOffsetSql(String baseSQL, int limit, int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("The offset must be greater than or equal to zero.(" + offset + ")");
        }
        StringBuffer sqlBuf = new StringBuffer(baseSQL);
        sqlBuf.insert(0, "SELECT * FROM (SELECT S2DAO_ORIGINAL_DATA.*, ROWNUM AS S2DAO_ROWNUMBER FROM (");
        sqlBuf.append(") S2DAO_ORIGINAL_DATA) WHERE S2DAO_ROWNUMBER BETWEEN ");
        sqlBuf.append(offset + 1);
        sqlBuf.append(" AND ");
        sqlBuf.append(offset + limit);
        sqlBuf.append(" AND ROWNUM <= ");
        sqlBuf.append(limit);
        sqlBuf.append(" ORDER BY S2DAO_ROWNUMBER");
        return sqlBuf.toString();
    }

    protected boolean isOriginalArgsRequiredForCounting() {
        return true;
    }
}

