/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DaoAnnotationReader;
import org.seasar.dao.DtoMetaData;
import org.seasar.dao.DtoMetaDataFactory;
import org.seasar.dao.RelationRowCreator;
import org.seasar.dao.ResultSetHandlerFactory;
import org.seasar.dao.RowCreator;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DtoArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.DtoListMetaDataResultSetHandler;
import org.seasar.dao.impl.DtoMetaDataResultSetHandler;
import org.seasar.dao.impl.MapArrayResultSetHandler;
import org.seasar.dao.impl.MapListResultSetHandler;
import org.seasar.dao.impl.MapResultSetHandler;
import org.seasar.dao.impl.ObjectArrayResultSetHandler;
import org.seasar.dao.impl.ObjectListResultSetHandler;
import org.seasar.dao.impl.ObjectResultSetHandler;
import org.seasar.dao.impl.RelationRowCreatorImpl;
import org.seasar.dao.impl.RowCreatorImpl;
import org.seasar.dao.util.TypeUtil;
import org.seasar.extension.jdbc.ResultSetHandler;

public class ResultSetHandlerFactoryImpl
implements ResultSetHandlerFactory {
    public static final String dtoMetaDataFactory_BINDING = "bindingType=must";
    protected DtoMetaDataFactory dtoMetaDataFactory;
    public static final String restrictNotSingleResult_BINDING = "bindingType=may";
    protected boolean restrictNotSingleResult = false;

    public ResultSetHandler getResultSetHandler(DaoAnnotationReader daoAnnotationReader, BeanMetaData beanMetaData, Method method) {
        Class beanClass = daoAnnotationReader.getBeanClass();
        Class clazz = daoAnnotationReader.getBeanClass(method);
        if (clazz != null && !clazz.isAssignableFrom(beanClass)) {
            if (TypeUtil.isSimpleType(clazz)) {
                if (List.class.isAssignableFrom(method.getReturnType())) {
                    return this.createObjectListResultSetHandler(clazz);
                }
                if (method.getReturnType().isArray() && !TypeUtil.isSimpleType(method.getReturnType())) {
                    return this.createObjectArrayResultSetHandler(clazz);
                }
                return this.createObjectResultSetHandler(clazz);
            }
            if (Map.class.isAssignableFrom(clazz)) {
                if (List.class.isAssignableFrom(method.getReturnType())) {
                    return this.createMapListResultSetHandler();
                }
                if (method.getReturnType().isArray()) {
                    return this.createMapArrayResultSetHandler();
                }
                return this.createMapResultSetHandler();
            }
            DtoMetaData dtoMetaData = this.dtoMetaDataFactory.getDtoMetaData(clazz);
            if (List.class.isAssignableFrom(method.getReturnType())) {
                return this.createDtoListMetaDataResultSetHandler(dtoMetaData);
            }
            if (method.getReturnType() == clazz) {
                return this.createDtoMetaDataResultSetHandler(dtoMetaData);
            }
            if (method.getReturnType().isArray()) {
                return this.createDtoArrayMetaDataResultSetHandler(dtoMetaData);
            }
        } else {
            if (List.class.isAssignableFrom(method.getReturnType())) {
                return this.createBeanListMetaDataResultSetHandler(beanMetaData);
            }
            if (this.isBeanClassAssignable(beanClass, method.getReturnType())) {
                return this.createBeanMetaDataResultSetHandler(beanMetaData);
            }
            if (method.getReturnType().isAssignableFrom(Array.newInstance(beanClass, 0).getClass())) {
                return this.createBeanArrayMetaDataResultSetHandler(beanMetaData);
            }
        }
        return this.createObjectResultSetHandler(null);
    }

    protected ResultSetHandler createDtoListMetaDataResultSetHandler(DtoMetaData dtoMetaData) {
        return new DtoListMetaDataResultSetHandler(dtoMetaData, this.createRowCreator());
    }

    protected ResultSetHandler createDtoMetaDataResultSetHandler(DtoMetaData dtoMetaData) {
        if (this.restrictNotSingleResult) {
            return new DtoMetaDataResultSetHandler.RestrictDtoMetaDataResultSetHandler(dtoMetaData, this.createRowCreator());
        }
        return new DtoMetaDataResultSetHandler(dtoMetaData, this.createRowCreator());
    }

    protected ResultSetHandler createDtoArrayMetaDataResultSetHandler(DtoMetaData dtoMetaData) {
        return new DtoArrayMetaDataResultSetHandler(dtoMetaData, this.createRowCreator());
    }

    protected ResultSetHandler createMapListResultSetHandler() {
        return new MapListResultSetHandler();
    }

    protected ResultSetHandler createMapResultSetHandler() {
        if (this.restrictNotSingleResult) {
            return new MapResultSetHandler.RestrictMapResultSetHandler();
        }
        return new MapResultSetHandler();
    }

    protected ResultSetHandler createMapArrayResultSetHandler() {
        return new MapArrayResultSetHandler();
    }

    protected ResultSetHandler createBeanListMetaDataResultSetHandler(BeanMetaData beanMetaData) {
        return new BeanListMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
    }

    protected ResultSetHandler createBeanMetaDataResultSetHandler(BeanMetaData beanMetaData) {
        if (this.restrictNotSingleResult) {
            return new BeanMetaDataResultSetHandler.RestrictBeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
        }
        return new BeanMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
    }

    protected ResultSetHandler createBeanArrayMetaDataResultSetHandler(BeanMetaData beanMetaData) {
        return new BeanArrayMetaDataResultSetHandler(beanMetaData, this.createRowCreator(), this.createRelationRowCreator());
    }

    protected ResultSetHandler createObjectListResultSetHandler(Class clazz) {
        return new ObjectListResultSetHandler(clazz);
    }

    protected ResultSetHandler createObjectResultSetHandler(Class clazz) {
        if (this.restrictNotSingleResult) {
            return new ObjectResultSetHandler.RestrictObjectResultSetHandler(clazz);
        }
        return new ObjectResultSetHandler(clazz);
    }

    protected ResultSetHandler createObjectArrayResultSetHandler(Class clazz) {
        return new ObjectArrayResultSetHandler(clazz);
    }

    protected RowCreator createRowCreator() {
        return new RowCreatorImpl();
    }

    protected RelationRowCreator createRelationRowCreator() {
        return new RelationRowCreatorImpl();
    }

    protected boolean isBeanClassAssignable(Class beanClass, Class clazz) {
        return beanClass.isAssignableFrom(clazz) || clazz.isAssignableFrom(beanClass);
    }

    public void setDtoMetaDataFactory(DtoMetaDataFactory dtoMetaDataFactory) {
        this.dtoMetaDataFactory = dtoMetaDataFactory;
    }

    public void setRestrictNotSingleResult(boolean restrictNotSingleResult) {
        this.restrictNotSingleResult = restrictNotSingleResult;
    }
}

