/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.engine;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;

import org.h2.command.CommandInterface;
import org.h2.message.Trace;
import org.h2.value.ValueLob;

public interface SessionInterface {
    CommandInterface prepareCommand(String sql) throws SQLException;
    void close() throws SQLException;
    Trace getTrace();
    ValueLob createClob(Reader in, long length) throws SQLException;
    ValueLob createBlob(InputStream stream, long length) throws SQLException;
    boolean isClosed();
    SessionInterface createSession(ConnectionInfo ci) throws SQLException;
    int getPowerOffCount();
    void setPowerOffCount(int i) throws SQLException;
}
