/*
 * Copyright 2006-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.codegen.util;

import static org.hamcrest.CoreMatchers.*;
import static org.junit.Assert.*;

import org.junit.Test;
import org.seasar.codegen.element.Field;
import org.seasar.codegen.element.PrimaryKey;

public class SequnceUtilTest {

    @Test
    public void シーケンスのマッピングが指定されている場合には主キーに指定される() throws Exception {
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKey.setField(new Field());
        SequnceUtil.addSequence(primaryKey, "AAA");
        assertThat(primaryKey.getField().getSequence(), is("AAA"));

    }

    @Test
    public void シーケンスのマッピングが指定されていない場合は何も指定されないこと() throws Exception {
        PrimaryKey primaryKey = new PrimaryKey();
        primaryKey.setField(new Field());
        SequnceUtil.addSequence(primaryKey, null);
        assertThat(primaryKey.getField().getSequence(), nullValue());

    }
}
